% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_qsm.R
\name{standardize_qsm}
\alias{standardize_qsm}
\title{Standardize QSM}
\usage{
standardize_qsm(cylinder)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}
}
\value{
Returns a data frame
}
\description{
Standardizes QSM variable names and ordering across different QSM software
}
\details{
Renames supported QSM software output columns to be consistent.
All names are lower case and underscore delimited. See the dictionary
vignette for a detailed description of column names. A consistent QSM format
ensures maximum compatibility when analyzing QSMs made with different
software. This function can be run either before or after the
update_cylinders function has been run, or at any stage.
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- standardize_qsm(cylinder)
str(cylinder)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- standardize_qsm(cylinder)
str(cylinder)

## aRchi Processing Chain
file <- system.file("extdata/QSM2.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- standardize_qsm(cylinder)
str(cylinder)

}
