% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_cloud.R
\name{cluster_cloud}
\alias{cluster_cloud}
\title{Cluster Cloud}
\usage{
cluster_cloud(cylinder, cloud = NULL, spacing = NULL)
}
\arguments{
\item{cylinder}{A QSM cylinder data frame.}

\item{cloud}{The input point cloud for the QSM to cluster. If NULL (default), the simulated cloud is returned.}

\item{spacing}{The point spacing in meters for the simulated cloud. Defaults to 0.02 meters.}
}
\value{
A point cloud data frame
}
\description{
Cluster a point cloud or simulate a point cloud based on its QSM.
If using the input point cloud, the the cylinder ids are transferred to the
cloud using the nearest neighbors. If simulating a cloud, the points are built
directly from the cylinders with user controlled spacing. The cylinder id can
be used to easily join the desired variables from the QSM to the cloud.
The nearest neighbor search uses the C++ nanoflann library.
}
\examples{

## Load Data
file <- system.file("extdata/QSM.mat", package = "rTwig")
file2 <- system.file("extdata/cloud.txt", package = "rTwig")

qsm <- run_rtwig(file, twig_radius = 4.23, metrics = FALSE)
cloud <- read.table(file2)

## Clustered Cloud
clustered_cloud <- cluster_cloud(cylinder = qsm, cloud = cloud)

# # Join QSM variables and export
# filename <- tempfile(pattern = "clustered_cloud", fileext = ".txt")
# clustered_cloud \%>\%
#   left_join(qsm) \%>\%
#   fwrite(file = filename)

## Simulated Cloud
simulated_cloud <- cluster_cloud(cylinder = qsm, spacing = 0.01)

# Plot Simulated Cloud
plot_qsm(cloud = simulated_cloud)

# # Join QSM variables and export
# filename2 <- tempfile(pattern = "simulated_cloud", fileext = ".txt")
# simulated_cloud \%>\%
#   left_join(qsm) \%>\%
#   fwrite(file = filename2)

}
\references{
\insertRef{blanco2014nanoflann}{rTwig}
}
