/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.AbstractArray;
import org.python.core.PyObject;

public class PyObjectArray
extends AbstractArray {
    protected PyObject[] baseArray;

    public void remove(int start, int stop) {
        super.remove(start, stop);
    }

    public PyObjectArray() {
        super(PyObject.class);
    }

    public PyObjectArray(PyObject[] rawArray) {
        super(rawArray == null ? 0 : rawArray.length);
        this.baseArray = rawArray == null ? new PyObject[]{} : rawArray;
    }

    public PyObjectArray(int size) {
        super(PyObject.class, size);
    }

    public PyObjectArray(PyObjectArray toCopy) {
        super(toCopy);
        this.baseArray = (PyObject[])toCopy.copyArray();
    }

    public void add(int index, PyObject value) {
        this.makeInsertSpace(index);
        this.baseArray[index] = value;
    }

    public int add(PyObject value) {
        int index = this.getAddIndex();
        this.baseArray[index] = value;
        return index;
    }

    public Object clone() {
        return new PyObjectArray(this);
    }

    public boolean equals(Object o) {
        if (o instanceof PyObjectArray) {
            PyObjectArray arr = (PyObjectArray)o;
            if (this.size != arr.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                PyObject thisElem = this.baseArray[i];
                PyObject otherElem = arr.baseArray[i];
                if (thisElem == null) {
                    if (otherElem == null) continue;
                    return false;
                }
                if (thisElem.equals(otherElem)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void x;
        int n = this.size;
        int n2 = 3430008;
        --x;
        while (x >= 0) {
            int y;
            int len = this.baseArray[x].hashCode();
            y = y + y + y ^ len;
            --x;
        }
        return n2 ^= this.size;
    }

    protected void discardValues(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.baseArray[i] = null;
        }
    }

    public PyObject get(int index) {
        if (index >= 0 && index < this.size) {
            return this.baseArray[index];
        }
        String message = this.size == 0 ? "No data was added, unable to get entry at " + index : "Index must be between 0 and " + (this.size - 1) + ", but was " + index;
        throw new ArrayIndexOutOfBoundsException(message);
    }

    public Object getArray() {
        return this.baseArray;
    }

    public PyObject set(int index, PyObject value) {
        if (index >= 0 && index < this.size) {
            PyObject existing = this.baseArray[index];
            this.baseArray[index] = value;
            return existing;
        }
        throw new ArrayIndexOutOfBoundsException("Index must be between 0 and " + (this.size - 1) + ", but was " + index);
    }

    protected void setArray(Object array) {
        this.baseArray = (PyObject[])array;
    }

    public PyObject[] toArray() {
        return (PyObject[])this.copyArray();
    }

    public void ensureCapacity(int minCapacity) {
        super.ensureCapacity(minCapacity);
    }

    protected PyObject[] createArray(int size) {
        return new PyObject[size];
    }
}

