/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrozenSet;
import org.python.core.PyFrozenSetDerived;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PySetDerived;
import org.python.core.PySetIterator;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.__builtin__;

public abstract class BaseSet
extends PyObject
implements Set {
    protected Set _set;

    protected BaseSet(Set set) {
        this._set = set;
    }

    protected BaseSet(PyType type, Set set) {
        super(type);
        this._set = set;
    }

    protected void _update(PyObject data) throws PyIgnoreMethodTag {
        BaseSet._update(this._set, data);
    }

    protected static Set _update(Set set, PyObject data) throws PyIgnoreMethodTag {
        if (data == null) {
            return set;
        }
        if (data instanceof BaseSet) {
            set.addAll(((BaseSet)data)._set);
            return set;
        }
        for (PyObject item : data.asIterable()) {
            set.add(item);
        }
        return set;
    }

    public PyObject __or__(PyObject other) {
        return this.baseset___or__(other);
    }

    final PyObject baseset___or__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.baseset_union(other);
    }

    public PyObject __and__(PyObject other) {
        return this.baseset___and__(other);
    }

    final PyObject baseset___and__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.baseset_intersection(other);
    }

    public PyObject __sub__(PyObject other) {
        return this.baseset___sub__(other);
    }

    final PyObject baseset___sub__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.difference(other);
    }

    public PyObject difference(PyObject other) {
        return this.baseset_difference(other);
    }

    final PyObject baseset_difference(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        Set set = bs._set;
        BaseSet o = BaseSet.makeNewSet(this.getType());
        for (Object p : this._set) {
            if (set.contains(p)) continue;
            o._set.add(p);
        }
        return o;
    }

    public PyObject __xor__(PyObject other) {
        return this.baseset___xor__(other);
    }

    final PyObject baseset___xor__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.symmetric_difference(other);
    }

    public PyObject symmetric_difference(PyObject other) {
        return this.baseset_symmetric_difference(other);
    }

    final PyObject baseset_symmetric_difference(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        BaseSet o = BaseSet.makeNewSet(this.getType());
        for (Object p : this._set) {
            if (bs._set.contains(p)) continue;
            o._set.add(p);
        }
        for (Object p : bs._set) {
            if (this._set.contains(p)) continue;
            o._set.add(p);
        }
        return o;
    }

    public abstract int hashCode();

    public int __len__() {
        return this.baseset___len__();
    }

    final int baseset___len__() {
        return this._set.size();
    }

    public boolean __nonzero__() {
        return !this._set.isEmpty();
    }

    public PyObject __iter__() {
        return this.baseset___iter__();
    }

    final PyObject baseset___iter__() {
        return new PySetIterator(this._set);
    }

    public boolean __contains__(PyObject other) {
        return this.baseset___contains__(other);
    }

    final boolean baseset___contains__(PyObject other) {
        try {
            return this._set.contains(other);
        }
        catch (PyException pye) {
            PyFrozenSet frozen = this.asFrozen(pye, other);
            return this._set.contains(frozen);
        }
    }

    public int __cmp__(PyObject other) {
        return this.baseset___cmp__(other);
    }

    final int baseset___cmp__(PyObject other) {
        throw Py.TypeError("cannot compare sets using cmp()");
    }

    public PyObject __eq__(PyObject other) {
        return this.baseset___eq__(other);
    }

    final PyObject baseset___eq__(PyObject other) {
        if (other instanceof BaseSet) {
            return Py.newBoolean(((Object)this._set).equals(((BaseSet)other)._set));
        }
        return Py.False;
    }

    public PyObject __ne__(PyObject other) {
        return this.baseset___ne__(other);
    }

    final PyObject baseset___ne__(PyObject other) {
        if (other instanceof BaseSet) {
            return Py.newBoolean(!((Object)this._set).equals(((BaseSet)other)._set));
        }
        return Py.True;
    }

    public PyObject __le__(PyObject other) {
        return this.baseset___le__(other);
    }

    final PyObject baseset___le__(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        return this.baseset_issubset(other);
    }

    public PyObject __ge__(PyObject other) {
        return this.baseset___ge__(other);
    }

    final PyObject baseset___ge__(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        return this.baseset_issuperset(other);
    }

    public PyObject __lt__(PyObject other) {
        return this.baseset___lt__(other);
    }

    final PyObject baseset___lt__(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        return Py.newBoolean(this.__len__() < bs.__len__() && this.baseset_issubset(other).__nonzero__());
    }

    public PyObject __gt__(PyObject other) {
        return this.baseset___gt__(other);
    }

    final PyObject baseset___gt__(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        return Py.newBoolean(this.__len__() > bs.__len__() && this.baseset_issuperset(other).__nonzero__());
    }

    public PyObject __reduce__() {
        return this.baseset___reduce__();
    }

    final PyObject baseset___reduce__() {
        PyTuple args = new PyTuple(new PyList(this));
        PyObject dict = this.__findattr__("__dict__");
        if (dict == null) {
            dict = Py.None;
        }
        return new PyTuple(this.getType(), args, dict);
    }

    public Object __tojava__(Class c) {
        if (Collection.class.isAssignableFrom(c)) {
            return Collections.unmodifiableSet(this._set);
        }
        return super.__tojava__(c);
    }

    final PyObject baseset_union(PyObject other) {
        BaseSet result = BaseSet.makeNewSet(this.getType(), this);
        result._update(other);
        return result;
    }

    final PyObject baseset_intersection(PyObject other) {
        PyObject big;
        PyObject little;
        if (!(other instanceof BaseSet)) {
            other = new PySet(other);
        }
        if (this.__len__() <= __builtin__.len(other)) {
            little = this;
            big = other;
        } else {
            little = other;
            big = this;
        }
        PyObject common = __builtin__.filter(big.__getattr__("__contains__"), little);
        return BaseSet.makeNewSet(this.getType(), common);
    }

    final PyObject baseset_copy() {
        BaseSet copy = BaseSet.makeNewSet(this.getType(), this);
        return copy;
    }

    final PyObject baseset_issubset(PyObject other) {
        BaseSet bs;
        BaseSet baseSet = bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        if (this.__len__() > bs.__len__()) {
            return Py.False;
        }
        for (Object p : this._set) {
            if (bs._set.contains(p)) continue;
            return Py.False;
        }
        return Py.True;
    }

    final PyObject baseset_issuperset(PyObject other) {
        BaseSet bs;
        BaseSet baseSet = bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        if (this.__len__() < bs.__len__()) {
            return Py.False;
        }
        for (Object p : bs._set) {
            if (this._set.contains(p)) continue;
            return Py.False;
        }
        return Py.True;
    }

    public String toString() {
        return this.baseset_toString();
    }

    final String baseset_toString() {
        String name = this.getType().fastGetName();
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return name + "(...)";
        }
        StringBuilder buf = new StringBuilder(name).append("([");
        Iterator i = this._set.iterator();
        while (i.hasNext()) {
            buf.append(((PyObject)i.next()).__repr__().toString());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("])");
        ts.exitRepr(this);
        return buf.toString();
    }

    protected final BaseSet _binary_sanity_check(PyObject other) throws PyIgnoreMethodTag {
        try {
            return (BaseSet)other;
        }
        catch (ClassCastException e) {
            throw Py.TypeError("Binary operation only permitted between sets");
        }
    }

    protected final PyFrozenSet asFrozen(PyException pye, PyObject value) {
        if (!(value instanceof BaseSet) || !Py.matchException(pye, Py.TypeError)) {
            throw pye;
        }
        PyFrozenSet tmp = new PyFrozenSet();
        tmp._set = ((BaseSet)value)._set;
        return tmp;
    }

    protected static BaseSet makeNewSet(PyType type) {
        return BaseSet.makeNewSet(type, null);
    }

    protected static BaseSet makeNewSet(PyType type, PyObject iterable) {
        BaseSet so;
        if (type == PySet.TYPE) {
            so = new PySet(iterable);
        } else if (type == PyFrozenSet.TYPE) {
            so = new PyFrozenSet(iterable);
        } else if (Py.isSubClass(type, PySet.TYPE)) {
            so = new PySetDerived(type);
            so._update(iterable);
        } else {
            so = new PyFrozenSetDerived(type, iterable);
        }
        return so;
    }

    public int size() {
        return this._set.size();
    }

    public void clear() {
        this._set.clear();
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public Object[] toArray() {
        return this._set.toArray();
    }

    public boolean add(Object o) {
        return this._set.add(o);
    }

    public boolean contains(Object o) {
        return this._set.contains(o);
    }

    public boolean remove(Object o) {
        return this._set.remove(o);
    }

    public boolean addAll(Collection c) {
        return this._set.addAll(c);
    }

    public boolean containsAll(Collection c) {
        return this._set.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this._set.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this._set.retainAll(c);
    }

    public Iterator iterator() {
        return this._set.iterator();
    }

    public Object[] toArray(Object[] a) {
        return this._set.toArray(a);
    }
}

