% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spdsplits.R
\name{get_spdsplits}
\alias{get_spdsplits}
\title{Get speed splits in a dataframe}
\usage{
get_spdsplits(act_id, stoken, units = "metric")
}
\arguments{
\item{act_id}{a vector of activity IDs. These are easily found in the \code{data.frame} returned by \code{\link{compile_activities}}}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{units}{chr string indicating plot units as either metric or imperial}
}
\value{
a data frame containing the splits of the activity or activities selected.
}
\description{
Allows the return of speed splits of multiple rides.
}
\examples{
\dontrun{
# get my activities
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))
my_acts <- get_activity_list(stoken)

# compile activities
acts_data <- compile_activities(my_acts)

# get spdsplits for all activities
spd_splits <- purrr::map_df(acts_data$id, get_spdsplits, stoken = stoken, 
     units = 'metric', .id = 'id')
}
}
\author{
Marcus Beck
}
\concept{token}
