% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_chemical.R
\name{describe_chemical}
\alias{describe_chemical}
\title{Describe Chemical Compound from RCSB PDB}
\usage{
describe_chemical(chem_id, url_root = URL_ROOT)
}
\arguments{
\item{chem_id}{A string representing the 3-character chemical ID. This ID is typically an alphanumeric string used to uniquely identify ligands, cofactors, or other small molecules within macromolecular structures. The string must not exceed 3 characters.}

\item{url_root}{A string representing the URL for retrieving information about chemical compounds. By default, this is set to the global constant \code{URL_ROOT}, but users can specify a different URL if needed.}
}
\value{
A list containing detailed information about the chemical compound. This list includes various fields such as:
\describe{
  \item{rcsb_chem_comp_descriptor}{A sublist containing chemical descriptors like SMILES, InChI strings, molecular weight, and other chemical properties.}
  \item{rcsb_chem_comp_info}{Information regarding the compound’s classification, formula, and additional relevant data.}
  \item{other}{Other fields may also be included, depending on the specific compound and the data available from the RCSB PDB.}
}
}
\description{
Retrieves detailed information about a chemical compound from the RCSB Protein Data Bank (PDB) based on its chemical ID.
}
\examples{
\dontrun{
# Retrieve chemical information for N-Acetyl-D-Glucosamine (NAG)
chem_desc <- describe_chemical('NAG')
chem_desc

# Access the SMILES string of the compound
smiles_string <- chem_desc$rcsb_chem_comp_descriptor$smiles
smiles_string

}
}
