% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_data.R
\name{fetch_data}
\alias{fetch_data}
\title{Fetch Data from RCSB PDB Using a JSON Query}
\usage{
fetch_data(json_query, data_type, ids)
}
\arguments{
\item{json_query}{A JSON string representing the query to be sent to the PDB.}

\item{data_type}{A string indicating the type of data to be fetched (not directly used in the function but may be relevant for context).}

\item{ids}{A vector of identifiers to fetch data for.}
}
\value{
A list containing the data fetched from the PDB, with the names of the list elements set to the corresponding IDs.
  If an error is encountered in the data fetching process, the function returns `NULL`.
}
\description{
This function sends a JSON query to the RCSB Protein Data Bank (PDB) and fetches the corresponding data.
It checks for errors in the response and warns if there are discrepancies in the number of IDs found.
}
