% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pdb_file.R
\name{get_pdb_file}
\alias{get_pdb_file}
\title{Download PDB Files from RCSB Database}
\usage{
get_pdb_file(
  pdb_id,
  filetype = "cif",
  rm.insert = FALSE,
  rm.alt = TRUE,
  compression = TRUE,
  save = FALSE,
  path = NULL
)
}
\arguments{
\item{pdb_id}{A 4-character string specifying a PDB entry of interest.}

\item{filetype}{The file type: 'pdb', 'cif', 'xml', or 'structfact'. Default is 'pdb'.pdb is the older file format and cif is the newer replacement. xlm is also can be obtained and parsed. structfact retrieves structure factors (only available for certain PDB entries).}

\item{rm.insert}{Logical, if TRUE PDB insert records are ignored.}

\item{rm.alt}{Logical, if TRUE PDB alternate records are ignored.}

\item{compression}{Logical indicating whether to request the data as a compressed version. Default is TRUE}

\item{save}{Logical, if TRUE saves PDB file to the desired path.}

\item{path}{The path where the file should be saved. If NULL, the file is saved in a temporary directory.}
}
\value{
Returns a list of class \code{"pdb"} with the following components:
\item{atom}{ a data.frame containing all atomic coordinate ATOM and
HETATM data, with a row per ATOM/HETATM and a column per record type.}
\item{xyz }{ a numeric matrix of class \code{"xyz"} containing the
ATOM and HETATM coordinate data. }
\item{calpha }{ logical vector with length equal to \code{nrow(atom)} with TRUE
values indicating a C-alpha \dQuote{elety}. }
\item{call }{ the matched call. }
}
\description{
This function downloads PDB files from the RCSB database, supporting different file types and optional compression.
It warns to consider compression for CIF files for faster download.
}
\examples{
pdb_file <-  get_pdb_file(pdb_id = "4HHB", filetype = "cif")
}
