% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{computePlacidoIndices}
\alias{computePlacidoIndices}
\title{Compute the Placido irregularity indices of a corneal dataset}
\usage{
computePlacidoIndices(
  datasetRings,
  truncateIndicesAt150 = TRUE,
  useMaxRings = 15
)
}
\arguments{
\item{datasetRings}{A dataset containing data points of a corneal topography, as given by \link[rPACI]{readFile} or \link[rPACI]{simulateData}.}

\item{truncateIndicesAt150}{A boolean value (by default \code{TRUE}) indicating whether the primary indices should be truncated at 150 (so they are in the range 0-150) or not.}

\item{useMaxRings}{A positive integer value (by default 15) to choose the maximum number of innermost rings to use (as long as there are enough).}
}
\value{
A \code{data.frame} containing the Placido irregularity indices as well as the diagnose, with columns:
\tabular{lll}{
  \code{Diagnose}   \tab\tab A text label indicating the diagnose, according to the value of GLPI\cr
  \code{NBI}   \tab\tab The value of NBI index (in the range 0-100).\cr
  \code{GLPI}  \tab\tab The value of GLPI index (in the range 0-100).\cr
  \code{PI_1}  \tab\tab The value of PI_1 index (usually in the range 0-150).\cr   
  \code{PI_2}  \tab\tab The value of PI_2 index (usually in the range 0-150).\cr   
  \code{PI_3}  \tab\tab The value of PI_3 index (usually in the range 0-150).\cr   
  \code{SL}  \tab\tab The value of SL index (usually in the range 0-150).\cr   
  \code{AR_1}  \tab\tab The value of AR_1 index (usually in the range 0-150).\cr
  \code{AR_2}  \tab\tab The value of AR_2 index (usually in the range 0-150).\cr   
  \code{AR_3}  \tab\tab The value of AR_3 index (usually in the range 0-150).\cr   
  \code{AR_4}  \tab\tab The value of AR_4 index (usually in the range 0-150).\cr   
  \code{AR_5}  \tab\tab The value of AR_5 index (usually in the range 0-150).\cr      
}
}
\description{
This function computes a set of indices or metrics from a \code{data.frame} which contains points measured from 
the cornea. The dataset may have been obtained reading from a corneal topography file with \link[rPACI]{readFile} 
or simulated with \link[rPACI]{simulateData}. These indices allow to discriminate between normal and irregular 
corneas. For more information on the indices and their precise mathematical definitions, see 
\href{../doc/indicesDefinition.html}{\code{vignette("indicesDefinition", package = "rPACI")}} or the references below.
}
\details{
The Placido irregularity indices can be computed from a \code{data.frame} in the format given by the functions
\link[rPACI]{readFile} (also with \link[rPACI]{readCSO} or \link[rPACI]{readrPACI}) or \link[rPACI]{simulateData}.

These irregularity indices can be split into two categories: primary and combined indices. 
The primary indices are: PI_1, PI_2, PI_3, SL, AR_1, AR_2, AR_3, AR_4, AR_5.
They all measure certain geometrical properties of the data distribution. Among these, the first 4 indices are 
especially important for the detection of keratoconus. Based on them, other combined indices are 
computed: GLPI (a generalized linear model) and NBI (naive Bayes index).

For more information on these indices and their precise mathematical definitions, see 
\href{../doc/indicesDefinition.html}{\code{vignette("indicesDefinition", package = "rPACI")}} or the references below.

They were introduced and validated with real datasets in 3 scientific papers (see the references below). In these 
papers, all indices demonstrated a good sensitivity for detection of keratoconus, a corneal disease. For more
details about corneal topography and keratoconus, see \href{../doc/topographersDataFormat.html}{\code{vignette("topographersDataFormat", package = "rPACI")}}

The results include the values of the indices (0 meaning normal, and a large positive value meaning irregular, 
check the range for each index) plus a diagnose, which is either "Irregular cornea", "Suspect cornea" or 
"Normal cornea", depending on the value of the combined index GLPI.
}
\examples{
# Read the file 'N02.txt' which is a real corneal topography (from a normal eye)
# that was measured with a CSO device:
dataset = readFile(system.file("extdata","N02.txt", package="rPACI"))

# Compute its Placido irregularity indices with this function:
results = computePlacidoIndices(dataset)
results
}
\references{
Castro-Luna, Gracia M., Andrei Martinez-Finkelshtein, and Dario Ramos-Lopez. 2020. "Robust Keratoconus Detection with Bayesian Network Classifier for Placido Based Corneal Indices." Contact Lens and Anterior Eye 43 (4): 366-72. \doi{10.1016/j.clae.2019.12.006}.

Ramos-Lopez, Dario, Andrei Martinez-Finkelshtein, Gracia M. Castro-Luna, Neus Burguera-Gimenez, Alfredo Vega-Estrada, David Pinero, and Jorge L. Alio. 2013. "Screening Subclinical Keratoconus with Placido-Based Corneal Indices." Optometry and Vision Science 90 (4): 335-43. \doi{10.1097/opx.0b013e3182843f2a}.

Ramos-Lopez, Dario, Andrei Martinez-Finkelshtein, Gracia M. Castro-Luna, David Pinero, and Jorge L. Alio. 2011. "Placido-Based Indices of Corneal Irregularity." Optometry and Vision Science 88 (10): 1220-31. \doi{10.1097/opx.0b013e3182279ff8}.
}
