% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode_generics.R, R/ODESolver.R,
%   R/AbstractODESolver.R, R/DormandPrince45.R, R/Euler.R, R/EulerRichardson.R,
%   R/RK4.R, R/Verlet.R
\docType{methods}
\name{init}
\alias{init}
\alias{init,ODESolver-method}
\alias{init,AbstractODESolver-method}
\alias{init,DormandPrince45-method}
\alias{init,Euler-method}
\alias{init,EulerRichardson-method}
\alias{init,RK4-method}
\alias{init,Verlet-method}
\title{Set initial values before starting the ODE solver}
\usage{
init(object, ...)

\S4method{init}{ODESolver}(object, stepSize, ...)

\S4method{init}{AbstractODESolver}(object, stepSize, ...)

\S4method{init}{DormandPrince45}(object, stepSize, ...)

\S4method{init}{Euler}(object, stepSize, ...)

\S4method{init}{EulerRichardson}(object, stepSize, ...)

\S4method{init}{RK4}(object, stepSize, ...)

\S4method{init}{Verlet}(object, stepSize, ...)
}
\arguments{
\item{object}{a class object}

\item{...}{additional parameters}

\item{stepSize}{size of the step}
}
\description{
Not all super classes require an init method.

Set initial values and get ready to start the solver
}
\examples{
# init method in Kepler.R
setMethod("init", "Kepler", function(object, initState, ...) {
    object@state <- initState
    object@odeSolver <- init(object@odeSolver, getStepSize(object@odeSolver))
    object@counter <- 0
    object
})

# init method in Logistic.R
setMethod("init", "Logistic", function(object, initState, r, K, ...) {
    object@r <- r
    object@K <- K
    object@state <- initState
    object@odeSolver <- init(object@odeSolver, getStepSize(object@odeSolver))
    object@counter <- 0
    object
})

# init method in Planet.R
setMethod("init", "Planet", function(object, initState, ...) {
    object@state <- object@odeSolver@ode@state <- initState
    # initialize providing the step size
    object@odeSolver <- init(object@odeSolver, getStepSize(object@odeSolver))
    object@rate <- object@odeSolver@ode@rate
    object@state <- object@odeSolver@ode@state
    object
})
}
