% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaston2neiGWAS.R
\name{gaston2neiGWAS}
\alias{gaston2neiGWAS}
\title{Convert \link{gaston}'s bed.matrix data to rNeighborGWAS genotype data.}
\usage{
gaston2neiGWAS(x)
}
\arguments{
\item{x}{A \link{bed.matrix} created using the \code{gaston} package (Perdry & Dandine-Roulland 2020).}
}
\value{
A list including an individual x marker matrix, a data.frame including chromosome numbers in the first column, and SNP positions in the second column, and a numeric vector including phenotypes for individuals.
\itemize{
\item{\code{geno}} {Individual x marker matrix}
\item{\code{gmap}} {Data.frame including chromosome numbers in the first column, and SNP positions in the second column}
\item{\code{pheno}} {Numeric vector including phenotypes for individuals}
}
}
\description{
A function convert a bed.matrix dataset to rNeighborGWAS genotype data.
}
\details{
This function converts genotype data into -1, 0, or 1 digit as the rNeighborGWAS format. Zero indicates heterozygotes.
}
\examples{
data("TTN", package="gaston")
x <- gaston::as.bed.matrix(TTN.gen, TTN.fam, TTN.bim)
g <- gaston2neiGWAS(x)
}
\references{
Perdry H, Dandine-Roulland C. (2020) gaston: Genetic Data Handling (QC, GRM, LD, PCA) & Linear Mixed Models. https://CRAN.R-project.org/package=gaston
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
