% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_growth_track.R
\name{ms.GrowthTrack}
\alias{ms.GrowthTrack}
\title{ms.GrowthTrack}
\usage{
ms.GrowthTrack(
  ticker,
  growth_amount = 10000,
  benchmark = "^GSPC",
  time_period = c("1m", "3m", "6m", "YTD", "1y", "3y", "5y", "max")
)
}
\arguments{
\item{ticker}{Fund TICKER}

\item{growth_amount}{Amount invested in the fund, Default: 10000}

\item{benchmark}{Benchmark to compare the fund with, Default: '^GSPC'}

\item{time_period}{Investment Horizon: c("1m", "3m", "6m", "YTD", "1y", "3y", "5y", "max")}
}
\value{
Plots the growth of the investment (Mutua Fund/ETFs) and compares it with provided benchmark
}
\description{
Plots the growth of input amount in a fund
}
\details{
Plots the cumulative groth of the fund in a mutual fund/ETFs and compares it with the input benchmark.
}
\examples{
ms.GrowthTrack('FXAIX', time_period = '3y')
}
