% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landsat_search.R
\name{landsat_search}
\alias{landsat_search}
\title{Search for Landsat8 Products IDs}
\usage{
landsat_search(min_date = "2017-03-01", max_date = Sys.Date(),
  country = NULL, path_master = NULL, row_master = NULL,
  source = "sat-api")
}
\arguments{
\item{min_date}{the start date of the products. Format should be \%Y-\%m-\%d}

\item{max_date}{the end date of the products. Format should be \%Y-\%m-\%d}

\item{country}{the country for which product ids is required. NULL if search is not on country. List of available countries are available at data(world_rowpath)}

\item{path_master}{vector of path numbers}

\item{row_master}{vector of row numbers corresponding to the path number. Check details}

\item{source}{search source. Default and recommended is sat-api. Available options: "sat-api", "aws", "usgs". For AWS it will return the Pre-Collection Scene IDs pre March 2017.}
}
\value{
dataframe with the product ids and the meta information (cloud cover, path/row) along with it.
If source is sat-api then raw value download links from all the sources (AWS, Google, ESPA) are also outputted
}
\description{
Search for landsat8 product IDs for a geography (country name or row/path) and a specific time duration.
}
\details{
for path_master and row_master input is in a pair. For example: If we want path/row of :  (147,47) , (147,48) then path_master = c(147, 147), row_master = c(47,48)
}
\examples{
# define the start and end dates
start = "2017-03-11"
end = "2017-03-12"

# Get for specific row and path
result = landsat_search(min_date=start, max_date=end, path_master=147, row_master=48)
\donttest{
# Get for entire country
 result = landsat_search(min_date=start, max_date=end, country = "India")
}

}
