% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMValues.R
\name{addMValues}
\alias{addMValues}
\title{Add M values to given feature}
\usage{
addMValues(sfDataObject)
}
\arguments{
\item{sfDataObject}{An sf object. Must be a LINESTRING, POLYGON, MULTIPOLYGON, or MULTILINESTRING}
}
\value{
Returns the new \code{sfDataObject} with added m-values. The class of the output is \code{sf}.
}
\description{
Add M values to a given linear feature and store them in the m-coordinate of the sf object. Returns
the new sf object with added m-values.
For more information on m-values and linear referencing see: 
\url{http://desktop.arcgis.com/en/arcmap/10.3/guide-books/linear-referencing/what-is-linear-referencing.htm}
}
\examples{
library(rLFT)
data("shpObject")
# Assign M Values to each vertex
mValues <- addMValues(shpObject)
print("M Values Added")
head(st_coordinates(mValues))

}
