% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.pca.R
\name{msc.pca}
\alias{msc.pca}
\title{Prinicple Component Analysis based on MSC}
\usage{
msc.pca(clustmatrix, samples, groups, n = 20, labels = TRUE, title = NULL)
}
\arguments{
\item{clustmatrix}{a cluster matrix}

\item{samples}{a vector containing the names of the samples. This can include all samples or it can be a subset.}

\item{groups}{a vector specifying to which group (e.g. species) the samples belong to.}

\item{n}{number of clusters to select with highest contribution to PCA.}

\item{labels}{a logical parameter indicating whether to use labels on the PCA plot or not. Default is set to true.}

\item{title}{the title of the graph}
}
\value{
\item{plot}{a PCA plot.}
\item{eigenvalues}{a barplot showing percentage of explained variances.}
\item{clustnames}{list of cluster names with highest contribution to PCA.}
}
\description{
The msc.pca allows you to perform Principle Component Analysis to summarize MSCs variation in all samples or in a subset of samples.
}
\examples{
data(matrices)
data(exData)

### run function with all samples
res.pca <- lapply(matrices, function(x) msc.pca(x, samples = exData$samples, 
                  groups = exData$species, n=30, labels=FALSE, title=NULL))

res.pca$id93$eigenvalues
res.pca$id93$plot

### use clusters with highest contribution to visualize in a heatmap
msc.heatmap(matrices[["id93"]][res.pca$id93$clustnames,], samples = exData$samples,
            groups = exData$species)

### run function with a subset of samples
### you will be asked to confirm
table(exData$species)
hybrid <- which(exData$species=="hybrid")
# pca.subset <- msc.pca(clustmatrix = matrices[["id97"]], 
#                       samples = exData$samples[hybrid], 
#                       groups = exData$species[hybrid], labels = TRUE, 
#                       title = "PCA only with hybrids")

}
