% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_java.R
\name{use_java}
\alias{use_java}
\title{Install specified Java version and set the \code{JAVA_HOME} and \code{PATH} environment variables in current R session}
\usage{
use_java(
  version = NULL,
  distribution = "Corretto",
  cache_path = getOption("rJavaEnv.cache_path"),
  platform = platform_detect()$os,
  arch = platform_detect()$arch,
  quiet = TRUE
)
}
\arguments{
\item{version}{\code{Integer} or \code{character} vector of length 1 for major version of Java to download or install. If not specified, defaults to the latest LTS version. Can be "8", "11", "17", "21", "22", or 8, 11, 17, 21, or 22.}

\item{distribution}{The Java distribution to download. If not specified, defaults to "Amazon Corretto". Currently only \href{https://aws.amazon.com/corretto/}{"Amazon Corretto"} is supported.}

\item{cache_path}{The destination directory to download the Java distribution to. Defaults to a user-specific data directory.}

\item{platform}{The platform for which to download the Java distribution. Defaults to the current platform.}

\item{arch}{The architecture for which to download the Java distribution. Defaults to the current architecture.}

\item{quiet}{A \code{logical} value indicating whether to suppress messages. Can be \code{TRUE} or \code{FALSE}.}
}
\value{
\code{NULL}. Prints the message that Java was set in the current R session if \code{quiet} is set to \code{FALSE}.
}
\description{
Using specified Java version, set the \code{JAVA_HOME} and \code{PATH} environment variables in the current R session. If Java distribtuion has not been downloaded yet, download it. If it was not installed into cache directory yet, install it there and then set the environment variables. This is intended as a quick and easy way to use different Java versions in R scripts that are in the same project, but require different Java versions. For example, one could use this in scripts that are called by \code{targets} package or \code{callr} package.
}
\examples{
\dontrun{

# set cache directory for Java to be in temporary directory
options(rJavaEnv.cache_path = tempdir())

# install and set Java 8 in current R session
use_java(8)
# check Java version
"8" == java_check_version_cmd(quiet = TRUE)
"8" == java_check_version_rjava(quiet = TRUE)

# install and set Java 17 in current R session
use_java(17)
# check Java version
"17" == java_check_version_cmd(quiet = TRUE)
"17" == java_check_version_rjava(quiet = TRUE)

}

}
