% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPAIProfile.R
\name{plotPAIProfile}
\alias{plotPAIProfile}
\title{Plot GEDI Plant Area Index (PAI) Profile}
\usage{
plotPAIProfile(level2BPAIProfile, beam = "BEAM0101", elev = TRUE)
}
\arguments{
\item{level2BPAIProfile}{A GEDI Level2B object (output of \code{\link[rGEDI:getLevel2BPAIProfile]{getLevel2BPAIProfile}} function).
An S4 object of class "data.table".}

\item{beam}{Select GEDI beam. Default is "BEAM0101". See details section.}

\item{elev}{If TRUE, elevation will be used for plotting the PAI profile. Otherwise,
height will be used instead.}
}
\value{
Returns a ggplot object. See \code{\link[ggplot2:ggplot]{ggplot}} package.
}
\description{
This functions plots Plant Area Index (PAI) Profile (GEDI level2B)
}
\details{
list of GEDI beams. See the output of \code{\link[rGEDI:getLevel2BPAIProfile]{getLevel2BPAIProfile}} function.
\itemize{
\item \emph{BEAM0000}
\item \emph{BEAM0001}
\item \emph{BEAM0010}
\item \emph{BEAM0011}
\item \emph{BEAM0101}
\item \emph{BEAM0110}
\item \emph{BEAM1000}
\item \emph{BEAM1011}
}
}
\examples{
# specify the path to GEDI level2B data (zip file)
level2B_fp_zip <- system.file("extdata",
                  "GEDI02_B_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Bpath <- unzip(level2B_fp_zip,exdir = dirname(level2B_fp_zip))

# Reading GEDI level2B data (h5 file)
level2b<-readLevel2B(level2Bpath=level2Bpath)

# Get Plant Area Volume Density profile
level2BPAIProfile<-getLevel2BPAIProfile(level2b)

# Plot Level2B PAI Profile
gprofile<-plotPAIProfile(level2BPAIProfile, beam="BEAM0101", elev=TRUE)



close(level2b)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi02_bv001/
}
