% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisTaperShape3d.R
\name{VisTaperShape3d}
\alias{VisTaperShape3d}
\title{3-D visualization of taper models}
\usage{
VisTaperShape3d(model,dbh,height,col, solid)
}
\arguments{
\item{model, }{taper model as an object of class "lm"}

\item{dbh, }{tree diameter at breast height, e.g. 35 cm}

\item{height, }{tree height, e.g. 25 m}

\item{col, }{taper color, e.g. "forestgreen"}

\item{solid, }{if TRUE (default) returns a solid 3d model. If FALSE, returns a 3d grid model}
}
\description{
VisTaperShape3d is used for visualizing taper models in 3-D
}
\examples{
\dontrun{
# Importing forest inventory data
data(ForestInv01) 

# setting model parametersdbh and ht
hi<-ForestInv01[,2]
di<-ForestInv01[,3]
ht<-ForestInv01[,4]
dbh<-ForestInv01[,5]

# fitting the fifth-degree polynomial taper model
fit <- poly5Model(dbh,ht,di,hi, plotxy=TRUE)

dbh<-30 # cm
height<-25 # m
model<-fit

library(rgl)
# Plotting the taper model in 3-D
VisTaperShape3d(fit,dbh,height,col="forestgreen",solid=TRUE)
box3d()
grid3d(c("x+","y+"))
aspect3d(0.3,0.3,1)
}
}
\author{
Carlos Alberto Silva and Joao Paulo Sardo Madi
}

