% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmFSA.R
\name{lmFSA}
\alias{lmFSA}
\title{rFSA: Feasible Solution Algorithm (FSA) for Linear Models}
\usage{
lmFSA(formula, data, fixvar = NULL, quad = FALSE, m = 2, numrs = 1,
  cores = 1, interactions = TRUE, criterion = r.squared, minmax = "max",
  ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted. See help(lm) for details.}

\item{data}{a data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model.}

\item{fixvar}{a variable to fix in the model. Usually a covariate that should always be included (Example: Age, Sex). Will still consider it with interactions. Default is NULL.}

\item{quad}{to include quadratic terms or not.}

\item{m}{order of terms to potentially include. If interactions is set to TRUE then m is the order of interactions to be considered. Defaults to 2. For Subset selection (interaction=F), m is the size of the subset to examine. Default is 2.}

\item{numrs}{number of random starts to perform.}

\item{cores}{number of cores to use while running. Note: Windows can only use 1 core. See mclapply for details. If function detects a Windows user it will automatically set cores=1.}

\item{interactions}{T or F for whether to include interactions in model. Defaults to FALSE.}

\item{criterion}{which criterion function to either maximize or minimize. For linear models one can use: r.squared, adj.r.squared, cv5.lmFSA (5 Fold Cross Validation error), cv10.lmFSA (10 Fold Cross Validation error), apress (Allen's Press Statistic), int.p.val (Interaction P-value), AIC, BIC.}

\item{minmax}{whether to minimize or maximize the criterion function}

\item{...}{arguments to be passed to the lm function}
}
\value{
returns a list of solutions and table of unique solutions.
$solutions is a matrix of fixed terms, start position, feasible solution, criterion function value (p-value of interaction), and number of swaps to solution.
$table is a matrix of the unique feasible solutions and how many times they occured out of the number of random starts chosen. It also returns any warning messages with these solutions in the last column.
$efficiency is text comparing how many models you ran during your FSA search compared to how many you would have done with exhaustive search. Note: The FSA algorithm takes additional time to run on top of the model checks that were done during the algorithm. This additional time is approximately 15% more time than if you had just ran the model checks.
}
\description{
A function using a Feasible Solution Algorithm to find a set of feasible solutions for a linear model of a specific form that could include mth-order interactions (Note that these solutions are optimal in the sense that no one swap to any of the variables will increase the criterion function.)
}
\details{
PLEASE NOTE: make sure categorical variables are factors or characters otherwise answers will not reflect the variable being treated as a continuous variable.
}
\examples{
#use mtcars package see help(mtcars)
data(mtcars)
colnames(mtcars)
fit<-lmFSA(formula="mpg~hp+wt",data=mtcars,fixvar="hp",
               quad=FALSE,m=2,numrs=10,cores=1)
print(fit) #print formulas of fitted models
summary(fit) #review
}

