% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/am_covariance_structure.R
\name{am_covariance_structure}
\alias{am_covariance_structure}
\title{Compute Diagonal plus Low Rank covariance structure under equilibrium assortative mating
#'}
\usage{
am_covariance_structure(beta, AF, r)
}
\arguments{
\item{beta}{vector of standardized diploid allele-substitution effects}

\item{AF}{vector of allele frequencies}

\item{r}{cross-mate phenotypic correlation}
}
\value{
Vector 'U' such that $D + U U^T$ corresponds to the expected haploid LD-matrix given the specified genetic architecture (encoded by 'beta' and 'AF') and cross-mate phenotypic correlation 'r'. It is assumed that the total phenotypic variance at generation zero is one.
}
\description{
Compute Diagonal plus Low Rank covariance structure under equilibrium assortative mating
#'
}
\examples{
set.seed(1)
h2_0 = .5; m = 200; n = 1000; r =.5; min_MAF=.1
betas <- rnorm(m,0,sqrt(h2_0/m))
afs <- runif(m, min_MAF, 1-min_MAF)
output <- am_covariance_structure(betas, afs, r)
}
