% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axisLabels.R
\name{amAxisLabels}
\alias{amAxisLabels}
\alias{amAxisLabelsCircular}
\title{Axis labels}
\usage{
amAxisLabels(
  color = NULL,
  fontSize = 18,
  fontWeight = "normal",
  fontFamily = NULL,
  rotation = 0,
  formatter = NULL
)

amAxisLabelsCircular(
  color = NULL,
  fontSize = 14,
  fontWeight = "normal",
  fontFamily = NULL,
  radius = NULL,
  relativeRotation = NULL
)
}
\arguments{
\item{color}{color of the labels}

\item{fontSize}{size of the labels}

\item{fontWeight}{font weight of the labels, it can be \code{"normal"},
\code{"bold"}, \code{"bolder"}, \code{"lighter"}, or a number in
\code{seq(100, 900, by = 100)}}

\item{fontFamily}{font family of the labels}

\item{rotation}{rotation angle}

\item{formatter}{this option defines the format of the axis labels;
this should be a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/}{number formatting string}
for a numeric axis, and a list created with
\code{\link{amDateAxisFormatter}} for a date axis}

\item{radius}{radius in percentage}

\item{relativeRotation}{relative rotation angle}
}
\value{
A list of settings for the labels of an axis.
}
\description{
Create a list of settings for the labels of an axis.
}
\note{
A color can be given by the name of a R color, the name of a CSS
  color, e.g. \code{"silver"} or \code{"fuchsia"}, an HEX code like
  \code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
  like \code{"hsl(360,11,255)"}.
}
