% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_DataSet.R, R/class_DataSet_setters.R
\docType{methods}
\name{initialize,DataSet-method}
\alias{addFieldMapping}
\alias{addFieldMapping,DataSet-method}
\alias{addStockEvent}
\alias{addStockEvent,DataSet,StockEventOrMissing-method}
\alias{dataSet}
\alias{initialize,DataSet-method}
\alias{setDataProvider,DataSet,ANY,ANY-method}
\alias{setFieldMappings}
\alias{setFieldMappings,DataSet,list-method}
\alias{setStockEvents}
\alias{setStockEvents,DataSet,list-method}
\title{Creates or updates a DataSet}
\usage{
\S4method{initialize}{DataSet}(.Object, compared = FALSE, dataProvider,
  fieldMappings, stockEvents, ...)

dataSet(compared = FALSE, dataProvider, fieldMappings, stockEvents, ...)

\S4method{setDataProvider}{DataSet,ANY,ANY}(.Object, dataProvider,
  keepNA = TRUE)

setFieldMappings(.Object, fieldMappings)

\S4method{setFieldMappings}{DataSet,list}(.Object, fieldMappings)

addFieldMapping(.Object, ...)

\S4method{addFieldMapping}{DataSet}(.Object, ...)

setStockEvents(.Object, stockEvents)

\S4method{setStockEvents}{DataSet,list}(.Object, stockEvents)

addStockEvent(.Object, stockEvent = NULL, ...)

\S4method{addStockEvent}{DataSet,StockEventOrMissing}(.Object,
  stockEvent = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{DataSet}.}

\item{compared}{\code{logical}.}

\item{dataProvider}{\code{data.frame}, the data set data.
Important: the data sets need to come pre-ordered in ascending order.
Data with incorrect order might result in visual and functional glitches on the chart.}

\item{fieldMappings}{\code{list} of field mappings.
Field mapping is an object with fromField and toField properties.
fromField is a name of your value field in dataProvider.
toField might be chosen freely,
it will be used to set value/open/close/high/low fields for the StockGraph.
Example: list(fromField = "val1", toField ="value").}

\item{stockEvents}{\linkS4class{StockEvent}.}

\item{...}{other properties of DataSet.}

\item{keepNA}{\code{logical}, TRUE to keep NA values.}

\item{stockEvent}{\linkS4class{StockEvent}.
Argument for method \code{addStockEvent}.}
}
\value{
(updated) \linkS4class{DataSet} object
}
\description{
Uses the constructors to create the object with its properties
or updates an existing one with the setters.
}
\examples{
new("DataSet")

dataSet(categoryField = "categoryField")

setDataProvider(.Object = dataSet(), data.frame(key = c("FR", "US"), value = c(20,10)))

dataset <- addFieldMapping(.Object = dataSet(),
                           fieldMappings = list(fromField ="val1", toField ="value"))
print(dataset)
dataset <- addFieldMapping(.Object = dataSet(), fromField ="val1", toField ="value")
print(dataset)
addStockEvent(.Object = dataSet(), backgroundAlpha = 1, backgroundColor = "#DADADA")
# equivalent to:
stockEvent_obj <- stockEvent(backgroundAlpha = 1, backgroundColor = "#DADADA")
chart <- addStockEvent(.Object = dataSet(), stockEvent = stockEvent_obj); print(chart)
}

