% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amTimeSeries.R
\name{amTimeSeries}
\alias{amTimeSeries}
\title{Plotting times series which aggregation}
\usage{
amTimeSeries(data, col_date, col_series, main = "", ylab = "",
  color = c("#2E2EFE", "#31B404", "#FF4000", "#AEB404"), bullet = NULL,
  bulletSize = 2, linetype = c(0, 5, 10, 15, 20), linewidth = c(1, 1, 1,
  1, 1, 1), aggregation = c("Average", "Low", "High", "Sum"),
  maxSeries = 300, groupToPeriods = c("ss", "mm", "hh", "DD", "MM", "YYYY"),
  ZoomButton = data.frame(Unit = "MAX", multiple = 1, label = "All"),
  ZoomButtonPosition = "bottom", precision = 1, export = FALSE,
  legendPosition = "bottom", scrollbarPosition = "bottom",
  scrollbarHeight = 40, creditsPosition = "top-right", ...)
}
\arguments{
\item{data}{\code{data.frame}, data of graph.}

\item{col_date}{\code{character} name of date column}

\item{col_series}{\code{character} names of series columns}

\item{main}{\code{character}, title.}

\item{ylab}{\code{character}, value axis label.}

\item{color}{\code{character}, color of series (in hexadecimal).}

\item{bullet}{\code{character}, point shape. Possible values are : "diamond", "square", 
"bubble",  "yError", "xError", "round", "triangleLeft", "triangleRight", "triangleUp"}

\item{bulletSize}{: \code{numeric}, size of bullet.}

\item{linetype}{: \code{numeric}, line type, 0 : solid, number : dashed length}

\item{linewidth}{: \code{numeric}, line width.}

\item{aggregation}{\code{character}, aggregation type. Possible values are : 
"Low", "High", "Average" and "Sum"}

\item{maxSeries}{\code{numeric} Maximum series shown at a time.
In case there are more data points in the selection than maxSeries,
the chart will group data to longer periods,
for example - you have 250 days in the selection,
and maxSeries is 150 - the chart will group data to weeks.}

\item{groupToPeriods}{\code{character}, Periods to which data will
be grouped in case there are more data items in the selected
period than specified in maxSeries property. Possible value are :
'ss', 'mm', 'hh', 'DD', 'MM', 'YYYY'. It's also possible to add multiple like "30mm".}

\item{ZoomButton}{\code{data.frame}, 3 columns : 
Unit, times unit
multiple : multiple*unit 
label : button's label}

\item{ZoomButtonPosition}{\code{character}, zoom button position. Possible values are :
"left", "right", "bottom", "top"}

\item{precision}{\code{numeric}, digits precision}

\item{export}{\code{logical}, default set to  FALSE. TRUE to display export feature.}

\item{legendPosition}{\code{character}, legend position. Possible values are :
"left", "right", "bottom", "top"}

\item{scrollbarPosition}{\code{character}, scrollbar position. Possible values are :
"left", "right", "bottom", "top"}

\item{scrollbarHeight}{\code{numeric}, height of scroll bar. Default : 40.}

\item{creditsPosition}{\code{character}, credits position. Possible values are :
"top-right", "top-left", "bottom-right", "bottom-left"}

\item{...}{other first level attributes}
}
\description{
amTimeSeries computes a stock chart.
}
\examples{
data("data_stock_2")
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"))

\donttest{
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round")
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
              groupToPeriods = c('hh', 'DD', '10DD'))

amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
              groupToPeriods = c('12hh', 'DD', '10DD'),
              maxSeries = 50)
              
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             groupToPeriods = c('hh', 'DD', '10DD'),
             linewidth = c(3, 1))



amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
              groupToPeriods = c('12hh', 'DD', '10DD'),
              maxSeries = 50, precision = 5)

amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet =  c("diamond", "square"),
             linetype = 0, bulletSize = c(5, 10),
             groupToPeriods = c('12hh', 'DD', '10DD'),
             maxSeries = 50, aggregation = "Sum")


ZoomButton <- data.frame(Unit = c("DD", "DD", "MAX"), multiple = c(1, 2 ,1),
                        label = c("Day","2 days", "MAX"))
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             ZoomButton = ZoomButton, main = "My title", ylab = "Interest")
             
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             ZoomButton = ZoomButton, main = "My title", ylab = "Interest",
             export = TRUE, ZoomButtonPosition = "right",
             legendPosition = "bottom", scrollbarPosition = "top")
         
amTimeSeries(data_stock_2, "date", c("ts1", "ts2"), bullet = "round",
             ZoomButton = ZoomButton, main = "My title",
             ylab = "Interest", export = TRUE,
             creditsPosition = "bottom-left")
             
}
}
\seealso{
\itemize{
\item{\url{https://datastorm-open.github.io/introduction_ramcharts/}}
}
}

