/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.TravelTimeComputer;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.transit.TransportNetwork;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.R5MultiDestinationProcess;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravelTimeMatrixComputer
extends R5MultiDestinationProcess {
    private static final int ROUTES_INDEX = 0;
    private static final int ACCESS_TIME_INDEX = 4;
    private static final int WAIT_TIME_INDEX = 7;
    private static final int RIDE_TIME_INDEX = 3;
    private static final int TRANSFER_TIME_INDEX = 6;
    private static final int EGRESS_TIME_INDEX = 5;
    private static final int COMBINED_TIME_INDEX = 8;
    private static final Logger LOG = LoggerFactory.getLogger(TravelTimeMatrixComputer.class);

    public TravelTimeMatrixComputer(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    @Override
    protected RDataFrame runProcess(int index) throws ParseException {
        RegionalTask request = this.buildRequest(index);
        request.percentiles = this.routingProperties.percentiles;
        request.includePathResults = this.routingProperties.travelTimesBreakdown;
        request.nPathsPerTarget = 1;
        TravelTimeComputer computer = new TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        OneOriginResult travelTimeResults = computer.computeTravelTimes();
        RDataFrame travelTimesTable = this.buildDataFrameStructure(this.fromIds[index], 10);
        this.populateDataFrame(travelTimeResults, travelTimesTable);
        if (travelTimesTable.nRow() > 0) {
            return travelTimesTable;
        }
        return null;
    }

    private void populateDataFrame(OneOriginResult travelTimeResults, RDataFrame travelTimesTable) {
        ArrayList[] pathResults = null;
        if (this.routingProperties.travelTimesBreakdown) {
            pathResults = travelTimeResults.paths.summarizeIterations(this.routingProperties.travelTimesBreakdownStat);
        }
        for (int destination = 0; destination < travelTimeResults.travelTimes.nPoints; ++destination) {
            if (travelTimeResults.travelTimes.getValues()[0][destination] > this.maxTripDuration) continue;
            travelTimesTable.append();
            travelTimesTable.set("toId", this.toIds[destination]);
            this.populateTravelTimes(travelTimeResults, travelTimesTable, destination);
            this.populateTravelTimesBreakdown(travelTimesTable, pathResults, destination);
        }
    }

    private void populateTravelTimes(OneOriginResult travelTimeResults, RDataFrame travelTimesTable, int destination) {
        if (this.routingProperties.percentiles.length == 1) {
            travelTimesTable.set("travel_time", travelTimeResults.travelTimes.getValues()[0][destination]);
        } else {
            for (int p = 0; p < this.routingProperties.percentiles.length; ++p) {
                int tt = travelTimeResults.travelTimes.getValues()[p][destination];
                String ps = String.format("%03d", this.routingProperties.percentiles[p]);
                if (tt >= this.maxTripDuration) continue;
                travelTimesTable.set("travel_time_p" + ps, tt);
            }
        }
    }

    private void populateTravelTimesBreakdown(RDataFrame travelTimesTable, ArrayList<String[]>[] pathResults, int destination) {
        if (this.routingProperties.travelTimesBreakdown & pathResults != null && !pathResults[destination].isEmpty()) {
            String[] a = pathResults[destination].get(0);
            String routes = a[0];
            travelTimesTable.set("routes", routes);
            if (!routes.equals("")) {
                travelTimesTable.set("n_rides", routes.split("\\|").length);
            }
            travelTimesTable.set("access_time", this.parseAndSumTravelTimes(a[4]));
            travelTimesTable.set("wait_time", this.parseAndSumTravelTimes(a[7]));
            travelTimesTable.set("ride_time", this.parseAndSumTravelTimes(a[3]));
            travelTimesTable.set("transfer_time", this.parseAndSumTravelTimes(a[6]));
            travelTimesTable.set("egress_time", this.parseAndSumTravelTimes(a[5]));
            travelTimesTable.set("combined_time", this.parseAndSumTravelTimes(a[8]));
        }
    }

    private double parseAndSumTravelTimes(String a) {
        if (a == null) {
            return 0.0;
        }
        if (a.equals("")) {
            return 0.0;
        }
        String[] b = a.split("\\|");
        return Arrays.stream(b).mapToDouble(s -> Double.parseDouble(s.replaceAll(",", "."))).sum();
    }

    @Override
    protected RDataFrame buildDataFrameStructure(String fromId, int nRows) {
        RDataFrame travelTimesTable = new RDataFrame(nRows);
        travelTimesTable.addStringColumn("fromId", fromId);
        travelTimesTable.addStringColumn("toId", "");
        if (this.routingProperties.percentiles.length == 1) {
            travelTimesTable.addIntegerColumn("travel_time", Integer.MAX_VALUE);
        } else {
            for (int p : this.routingProperties.percentiles) {
                String ps = String.format("%03d", p);
                travelTimesTable.addIntegerColumn("travel_time_p" + ps, Integer.MAX_VALUE);
            }
        }
        if (this.routingProperties.travelTimesBreakdown) {
            travelTimesTable.addDoubleColumn("access_time", 0.0);
            travelTimesTable.addDoubleColumn("wait_time", 0.0);
            travelTimesTable.addDoubleColumn("ride_time", 0.0);
            travelTimesTable.addDoubleColumn("transfer_time", 0.0);
            travelTimesTable.addDoubleColumn("egress_time", 0.0);
            travelTimesTable.addDoubleColumn("combined_time", 0.0);
            travelTimesTable.addStringColumn("routes", "");
            travelTimesTable.addIntegerColumn("n_rides", 0);
        }
        return travelTimesTable;
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.destinationPointSets = new PointSet[1];
        request.destinationPointSets[0] = this.destinationPoints;
        return request;
    }
}

