% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r4ss-package.R
\docType{package}
\name{r4ss-package}
\alias{r4ss}
\alias{r4ss-package}
\title{R tools for Stock Synthesis}
\description{
A collection of R functions for use with Stock Synthesis, a fisheries stock
assessment modeling platform written in ADMB by Dr. Richard D.  Methot at
the NMFS Northwest Fisheries Science Center. The functions include tools for
summarizing and plotting results, manipulating files, visualizing model
parameterizations, and various other tasks.
}
\details{
\tabular{ll}{ Package: \tab r4ss\cr Type: \tab Package\cr Version: \tab
1.24.0\cr Date: \tab 2015-12-15\cr License: \tab GPL-3\cr LazyLoad: \tab
yes\cr URL: \tab \url{https://github.com/r4ss/}\cr }
Should be compatible with Stock Synthesis versions 3.20 through 3.30.
}
\examples{

\dontrun{
# read in the report file using SS_output
myreplist <- SS_output(dir='c:/SS/simple/')

# make a collection of plots using SS_plots
SS_plots(replist=myreplist)
}

}
\author{
Ian G. Taylor, Ian J. Stewart, Allan C. Hicks, Tommy M. Garrison,
Andre E. Punt, John R. Wallace, Chantel R. Wetzel, James T. Thorson,
Yukio Takeuchi, Kotaro Ono, Cole C. Monnahan, Christine C. Stawitz,
Z. Teresa A'mar, Athol R. Whitten, Kelli F. Johnson, Robbie L. Emmet,
Sean C. Anderson, and other contributors.
 Package maintainer: Ian Taylor <Ian.Taylor@noaa.gov>
}
\references{
r4ss on GitHub: \url{https://github.com/r4ss}
\cr Download Stock Synthesis: \url{http://nft.nefsc.noaa.gov/}
}
\keyword{package}

