% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_isosurface}
\alias{m_add_isosurface}
\title{Construct isosurface from volumetric data in gaussian cube format}
\usage{
m_add_isosurface(id, data, isoSpec)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{data}{Path of input data path or a vector of data.}

\item{isoSpec}{Volumetric data shape specification}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Construct isosurface from volumetric data in gaussian cube format
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_isosurface(
    data = cube_benzene_homo,
    isoSpec = list(
      isoval = -0.01,
      color = "red",
      opacity = 0.95
    )
  ) \%>\%
  m_zoom_to()
}
