% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_plot.R
\name{scatter_plot}
\alias{scatter_plot}
\title{Scatter Plot and Scatter Plot Matrix}
\usage{
scatter_plot(data, variables, version = r2spss_options$get("version"), ...)
}
\arguments{
\item{data}{a data frame containing the variables to be plotted.}

\item{variables}{a character vector specifying at least two variables to be
plotted.  In case of two variables, a simple scatter plot is produced with
the first variable on the \eqn{x}-axis and the second variable on the
\eqn{y}-axis.  In case of more than two variables, a scatter plot matrix is
produced.}

\item{version}{a character string specifying whether the plot should mimic
the look of recent SPSS versions (\code{"modern"}) or older versions (<24;
\code{"legacy"}).}

\item{\dots}{for a simple scatter plot, additional arguments are passed
down to \code{\link[ggplot2]{geom_point}}.  For a scatter plot matrix,
additional arguments to be passed down, in particular base graphics
parameters (see \code{\link[graphics]{par}}).}
}
\value{
In case of a simple scatter plot, an object of class
\code{"\link[ggplot2]{ggplot}"}, which produces the plot when printed.

In case of a scatter plot matrix, nothing is returned but a plot is produced.
}
\description{
Draw a scatter plot or a scatter plot matrix of variables in a data frame.
The plots thereby mimic the look of SPSS graphs.
}
\note{
Wile all other plots in \pkg{r2spss} are based on
\pkg{\link[ggplot2:ggplot2-package]{ggplot2}} (including the simple scatter
plot), the scatter plot matrix is built around base \R graphics.  This is
because \pkg{ggplot2} does not provide an implementation of a scatter plot
matrix, and an implementation based on separate scatter plots on a matrix
layout would be slow.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# plot log market values against age
scatter_plot(Eredivisie, c("Age", "logMarketValue"))

# scatterplot matrix of age, number of minutes played, and
# log market values
scatter_plot(Eredivisie, c("Age", "Minutes", "logMarketValue"))

}
\author{
Andreas Alfons
}
\keyword{hplot}
