% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_SPSS.R
\name{format_SPSS}
\alias{format_SPSS}
\alias{format_SPSS.default}
\alias{format_SPSS.integer}
\alias{format_SPSS.numeric}
\alias{format_SPSS.matrix}
\alias{format_SPSS.data.frame}
\alias{formatSPSS}
\title{Format Objects}
\usage{
format_SPSS(object, ...)

\method{format_SPSS}{default}(object, ...)

\method{format_SPSS}{integer}(object, ...)

\method{format_SPSS}{numeric}(object, digits = 3, p_value = FALSE, check_int = FALSE, ...)

\method{format_SPSS}{matrix}(object, digits = 3, p_value = FALSE, check_int = FALSE, ...)

\method{format_SPSS}{data.frame}(object, digits = 3, p_value = FALSE, check_int = FALSE, ...)

formatSPSS(object, ...)
}
\arguments{
\item{object}{an \R object.  Currently methods are implemented
for vectors, matrices, and data frames.  The default method calls
\code{\link{as.character}}.}

\item{\dots}{additional arguments passed down to methods.}

\item{digits}{an integer giving the number of digits after the comma to
display.}

\item{p_value}{a logical indicating whether small positive values should be
indicated as below the threshold defined by \code{digits}, e.g.,
\code{"<.001"} if \code{digits = 3}.  This is used for formatting p-values
in LaTeX tables that mimic the look of SPSS.  For the \code{"numeric"}
method, a logical vector indicates the behavior for each element of
\code{object}.  For the \code{"matrix"} or \code{"data.frame"} methods, a
logical vector indicates the behavior for each column of \code{object}.}

\item{check_int}{a logical indicating whether to check for integer values
and format them as such, e.g., to format the integer \code{2} as \code{"2"}
instead of \code{"2.000"} if \code{digits = 3}.  For the \code{"numeric"}
method, a logical vector indicates the behavior for each element of
\code{object}.  For the \code{"matrix"} or \code{"data.frame"} methods, a
logical vector indicates the behavior for each column of \code{object}.}
}
\value{
A character vector, matrix, or data frame containing the formatted
object.
}
\description{
Format an object for printing, mostly used to print numeric data in the same
way as SPSS.  This is mainly for internal use in \code{\link{to_SPSS}} and
\code{\link{print}} methods.
}
\examples{
# note how numbers in the interval (-1, 1) are printed
# without the zero in front of the comma
format_SPSS(c(-1.5, -2/3, 2/3, 1.5))

}
\author{
Andreas Alfons
}
\keyword{utilities}
