% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_body.R
\name{rtf_body}
\alias{rtf_body}
\title{Add Table Body Attributes to the Table}
\usage{
rtf_body(
  tbl,
  col_rel_width = rep(1, ncol(tbl)),
  as_colheader = TRUE,
  border_left = "single",
  border_right = "single",
  border_top = NULL,
  border_bottom = NULL,
  border_first = "single",
  border_last = "single",
  border_color_left = NULL,
  border_color_right = NULL,
  border_color_top = NULL,
  border_color_bottom = NULL,
  border_color_first = NULL,
  border_color_last = NULL,
  border_width = 15,
  cell_height = 0.15,
  cell_justification = "c",
  cell_vertical_justification = "top",
  cell_nrow = NULL,
  text_font = 1,
  text_format = NULL,
  text_font_size = 9,
  text_color = NULL,
  text_background_color = NULL,
  text_justification = NULL,
  text_indent_first = 0,
  text_indent_left = 0,
  text_indent_right = 0,
  text_space = 1,
  text_space_before = 15,
  text_space_after = 15,
  text_convert = TRUE,
  group_by = NULL,
  page_by = NULL,
  new_page = FALSE,
  pageby_header = TRUE,
  pageby_row = "column",
  subline_by = NULL,
  last_row = TRUE
)
}
\arguments{
\item{tbl}{A data frame.}

\item{col_rel_width}{Column relative width in a vector e.g. c(2,1,1) refers to 2:1:1.
Default is NULL for equal column width.}

\item{as_colheader}{A boolean value to indicate whether to add default column header to the table.
Default is TRUE to use data frame column names as column header.}

\item{border_left}{Left border type. To vary left border by column, use
character vector with length of vector equal to number of columns displayed
e.g. c("single","single","single"). All possible input can be found in
\code{r2rtf:::border_type()$name}.}

\item{border_right}{Right border type. To vary right border by column, use
character vector with length of vector equal to number of columns displayed
e.g. c("single","single","single"). All possible input can be found in
\code{r2rtf:::border_type()$name}.}

\item{border_top}{Top border type. To vary top border by column, use
character vector with length of vector equal to number of columns displayed
e.g. c("single","single","single"). If it is the first row in a table for this
page, the top border is set to "double" otherwise the border is set to "single".
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_bottom}{Bottom border type.
To vary bottom border by column, use character vector with length of vector
equal to number of columns displayed e.g. c("single","single","single").
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_first}{First top border type of the whole table.
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_last}{Last bottom border type of the whole table.
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_color_left}{Left border color type. Default is NULL for black. To vary left
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_right}{Right border color type. Default is NULL for black. To vary right
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_top}{Top border color type. Default is NULL for black. To vary top
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_bottom}{Bottom border color type. Default is NULL for black. To vary bottom
border color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_first}{First top border color type of the whole table. Default is NULL for black.
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_last}{Last bottom border color type of the whole table. Default is NULL for black.
All possible input can be found in \code{grDevices::colors()}.}

\item{border_width}{Border width in twips. Default is 15 for 0.0104 inch.}

\item{cell_height}{Cell height in inches. Default is 0.15 for 0.15 inch.}

\item{cell_justification}{Justification type for cell.
All possible input can be found in \code{r2rtf:::justification()$type}.}

\item{cell_vertical_justification}{Vertical justification type for cell.
All possible input can be found in \code{r2rtf:::vertical_justification()$type}.}

\item{cell_nrow}{Number of rows required in each cell.}

\item{text_font}{Text font type. Default is 1 for Times New Roman. To vary text font type
by column, use numeric vector with length of vector equal to number of
columns displayed e.g. c(1,2,3).All possible input can be found
in \code{r2rtf:::font_type()$type}.}

\item{text_format}{Text format type. Default is NULL for normal. Combination of format type
are permitted as input for e.g. "ub" for bold and underlined text. To vary
text format by column, use character vector with length of vector equal to
number of columns displayed e.g. c("i","u","ib"). All possible input
can be found in \code{r2rtf:::font_format()$type}.}

\item{text_font_size}{Text font size.  To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{text_color}{Text color type. Default is NULL for black. To vary text color by column,
use character vector with length of vector equal to number of columns
displayed e.g. c("white","red","blue"). All possible input can be found
in \code{grDevices::colors()}.}

\item{text_background_color}{Text background color type. Default is NULL for white. To vary
text color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{text_justification}{Justification type for text. Default is "c" for center justification.
To vary text justification by column, use character vector with
length of vector equal to number of columns displayed e.g. c("c","l","r").
All possible input can be found in \code{r2rtf:::justification()$type}.}

\item{text_indent_first}{A value of text indent in first line. The unit is twip.}

\item{text_indent_left}{A value of text left indent. The unit is twip.}

\item{text_indent_right}{A value of text right indent. The unit is twip.}

\item{text_space}{Line space between paragraph in twips. Default is 0.}

\item{text_space_before}{Line space before a paragraph in twips.}

\item{text_space_after}{Line space after a paragraph in twips.}

\item{text_convert}{A logical value to convert special characters.}

\item{group_by}{A character vector of variable names in \code{tbl}.}

\item{page_by}{Column names in a character vector to group by table in sections.}

\item{new_page}{A boolean value to indicate whether to separate grouped table into pages
by sections. Default is FALSE.}

\item{pageby_header}{A boolean value to display pageby header at the beginning of each page.}

\item{pageby_row}{A character vector of location of page_by variable. Possible input are 'column'
or 'first_row'.}

\item{subline_by}{Column names in a character vector to subline by table in sections.}

\item{last_row}{A boolean value to indicate whether the table contains the last row of the
final table.}
}
\value{
the same data frame \code{tbl} with additional attributes for table body
}
\description{
Add Table Body Attributes to the Table
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if input tbl argument is of type data.frame.
   \item Validate if input column relative width argument is of type integer or numeric.
   \item Validate if input column header argument is of type logical.
   \item Validate if input border and border color arguments are of type character.
   \item Validate if input border width and cell height arguments are of type integer or numeric.
   \item Validate if input cell justification argument is of type character.
   \item Validate if input text font, font size, space before and space after arguments are of type integer or numeric.
   \item Validate if input text format, color, background color and justification arguments are of type character.
   \item Validate if input group by and page by arguments are of type character.
   \item Validate if input new page, pageby header and last row arguments are of type integer or numeric.
   \item Validate if input border left, right, top, bottom, first and last arguments are valid using \code{border_type()$name}.
   \item Validate if input border color left, right, top, bottom, first and last arguments are valid using \code{colors()}.
   \item Validate if input text color and background color arguments are valid using \code{colors()}.
   \item Validate if input cell justification and text justification arguments are valid using \code{justification()$type}.
   \item Validate if input text font argument is valid using \code{font_type()$type}.
   \item Validate if input text format argument is valid using \code{font_format()$type}.
   \item Validate if input border width, cell height and text font size arguments are greater than 0.#'
   \item Validate if input text space before and text space after arguments are greater than or equal to 0.
   \item Add default page attributes if missing for input table data frame using \code{rtf_page()}.
   \item Add page attribute use_color as TRUE if the input text, background or border color arguments are not black.
   \item Add column header attribute rtf_colheader if input column header argument is TRUE using \code{rtf_colheader()}.
   \item Add black as default text color attribute if input text background color argument is not NULL and text color argument is NULL.
   \item Define matrices of same dimensions as input table data frame for non missing input arguments for border top, bottom, left, right, first and last.
   \item Define matrices of same dimensions as input table data frame for non missing input arguments for border color top, bottom, left, right, first and last.
   \item Define matrices of same dimensions as input table data frame for non missing input arguments for text font, format, color, background color, justification and font size.
   \item Add the defined matrices as attributes to input table data frame.
   \item Define pageby attributes using input page by, new page, pageby header arguments and \code{rtf_pageby()}.
   \item Define table body attributes of \code{tbl} based on the input.
   \item Return \code{tbl}.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr) # required to run examples
data(r2rtf_tbl1)
r2rtf_tbl1 \%>\%
  rtf_body(
    col_rel_width = c(3, 1, 3, 1, 3, 1, 3, 5),
    text_justification = c("l", rep("c", 7)),
    last_row = FALSE
  ) \%>\%
  attributes()
}
