% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_page.R
\name{rtf_page}
\alias{rtf_page}
\title{Add RTF File Page Information}
\usage{
rtf_page(
  tbl,
  orientation = "portrait",
  width = ifelse(orientation == "portrait", 8.5, 11),
  height = ifelse(orientation == "portrait", 11, 8.5),
  margin = set_margin("wma", orientation),
  nrow = ifelse(orientation == "portrait", 40, 24),
  border_first = "double",
  border_last = "double",
  border_color_first = NULL,
  border_color_last = NULL,
  col_width = width - ifelse(orientation == "portrait", 2.25, 2.5)
)
}
\arguments{
\item{tbl}{A data frame.}

\item{orientation}{Orientation in 'portrait' or 'landscape'.}

\item{width}{A numeric value of page width in inches.
Default is 8.5 inch in portrait orientation or 11.0 inch in landscape orientation.}

\item{height}{A numeric value of page width in inches.
Default is 11.0 inch in portrait orientation or 8.5 inch in landscape orientation.}

\item{margin}{A numeric vector of length 6 for page margin. The value set left, right, top, bottom, header and footer
margin in order. Default value depends on the page orientation and set by \code{r2rtf:::set_margin("wma", orientation)}}

\item{nrow}{Number of rows in each page. Default is 42 rows if portrait orientation
and 26 rows in landscape orientation.}

\item{border_first}{First top border type of the whole table. Default is "double" indicating double line bottom border.
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_last}{Last bottom border type of the whole table. Default is "double" indicating double line bottom border.
All possible input can be found in \code{r2rtf:::border_type()$name}.}

\item{border_color_first}{First top border color type of the whole table. Default is NULL for black.
All possible input can be found in \code{grDevices::colors()}.}

\item{border_color_last}{Last bottom border color type of the whole table. Default is NULL for black.
All possible input can be found in \code{grDevices::colors()}.}

\item{col_width}{A numeric value of total column width in inch. Default is \code{width - ifelse(orientation == "portrait", 2, 2.5)}}
}
\value{
the same data frame \code{tbl} with additional attributes for page features
}
\description{
Add RTF File Page Information
}
\section{Specification}{

\if{latex}{
 \itemize{

   \item Check if all argument types and values are valid inputs.
   \item Add attributes to `tbl` based on the inputs.
   \item Register the use of color in page attributes.
   \item Return to `tbl` with page attributes.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr) # required to run examples
data(r2rtf_tbl1)
r2rtf_tbl1 \%>\%
  rtf_page() \%>\%
  attr("page")
}
