% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2pmml.R
\name{r2pmml}
\alias{r2pmml}
\title{Converts an R model object to PMML.}
\usage{
r2pmml(x, file, converter = NULL, converter_classpath = NULL,
  verbose = FALSE, ...)
}
\arguments{
\item{x}{An R model object.}

\item{file}{A filesystem path to the result file.}

\item{converter}{The name of a custom JPMML-R converter class.}

\item{converter_classpath}{A list of filesystem paths to library JAR files that provide and support the custom JPMML-R converter class.}

\item{verbose}{A flag controlling the verbosity of the conversion process.}

\item{...}{Arguments to be passed on to the "r2pmml::decorate" function.}
}
\description{
Converts an R model object to PMML.
}
\examples{
library("mlbench")
library("randomForest")
library("r2pmml")

data(iris)
iris.rf = randomForest(Species ~ ., data = iris, ntree = 7)
# Convert "randomForest" object to R-style (deep binary splits) MiningModel
pmmlFile = file.path(tempdir(), "Iris-RandomForest.pmml")
r2pmml(iris.rf, pmmlFile)
# Convert "randomForest" object to PMML-style (shallow multi-way splits) MiningModel
compactPmmlFile = file.path(tempdir(), "Iris-RandomForest-compact.pmml")
r2pmml(iris.rf, compactPmmlFile, compact = TRUE)

data(BostonHousing)
housing.glm = glm(medv ~ ., data = BostonHousing, family = "gaussian")
# Convert "glm" object into GeneralRegressionModel
genRegPmmlFile = file.path(tempdir(), "Housing-GLM.pmml")
r2pmml(housing.glm, genRegPmmlFile)
# Convert "glm" object into RegressionModel
regPmmlFile = file.path(tempdir(), "Housing-LM.pmml")
r2pmml(housing.glm, regPmmlFile, converter = "org.jpmml.rexp.LMConverter")
}
