% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{cal_2d_dist}
\alias{cal_2d_dist}
\title{Calculate 2D Euclidean distances between vertices}
\usage{
cal_2d_dist(tr_coord_df, start_x, start_y, end_x, end_y, select_vars)
}
\arguments{
\item{tr_coord_df}{A data frame containing columns for the
x and y coordinates of start and end points.}

\item{start_x}{Column name for the x-coordinate of the starting point.}

\item{start_y}{Column name for the y-coordinate of the starting point.}

\item{end_x}{Column name for the x-coordinate of the ending point.}

\item{end_y}{Column name for the y-coordinate of the ending point.}

\item{select_vars}{A character vector specifying the columns to be
selected in the resulting data frame.}
}
\value{
A data frame with columns for the starting point, ending point,
and calculated distances.
}
\description{
This function calculates the 2D distances between pairs of points in a data frame.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
all_centroids_df <- as.data.frame(do.call(cbind, hb_obj$centroids))
counts_df <- as.data.frame(do.call(cbind, hb_obj$std_cts))
df_bin_centroids <- extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)
tr1_object <- tri_bin_centroids(hex_df = df_bin_centroids, x = "c_x", y = "c_y")
tr_from_to_df <- gen_edges(tri_object = tr1_object)
cal_2d_dist(tr_coord_df = tr_from_to_df, start_x = "x_from", start_y = "y_from",
end_x = "x_to", end_y = "y_to", select_vars = c("from", "to", "distance"))

}
