% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-releases.R
\docType{class}
\name{releases-class}
\alias{releases-class}
\title{An S4 class to represent a set of PGS Catalog Releases}
\description{
The releases object consists of four tables (slots) that combined form a
relational database of a subset of PGS Catalog releases. Each release is an
observation (row) in the \code{releases} table (first table).
}
\section{Slots}{

\describe{
\item{\code{releases}}{A table of PGS Catalog releases. Each release (row) is
  uniquely identified by the release date (\code{date}). Columns:
\describe{
\item{date}{Release date.}
\item{n_pgs}{Number of newly released Polygenic Scores.}
\item{n_ppm}{Number of newly released PGS Performance Metrics.}
\item{n_pgp}{Number of newly released PGS Publications.}
}}

\item{\code{pgs_ids}}{A table of released Polygenic Scores (PGS) identifiers.
  Columns:
\describe{
\item{date}{Release date.}
\item{pgs_id}{Polygenic Score (PGS) identifier. Example: \code{"PGS000001"}.}
}}

\item{\code{ppm_ids}}{A table of the released PGS Performance Metrics identifiers.
  Columns:
\describe{
\item{date}{Release date.}
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
}}

\item{\code{pgp_ids}}{A table of the released PGS Publication identifiers. Columns:
\describe{
\item{date}{Release date.}
\item{pgp_id}{PGS Publication identifier. Example: \code{"PGP000001"}.}
}}
}}

