% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{request_all}
\alias{request_all}
\title{Request a paginated resource from the PGS REST API}
\usage{
request_all(
  resource_url = "/",
  base_url = pgs_server(),
  limit = 20L,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{resource_url}{Endpoint URL. The endpoint is internally appended to the
\code{base_url}. It should start with a forward slash (\code{/}).}

\item{base_url}{The PGS REST API base URL (one should not need to change its
default value).}

\item{limit}{number of results per page.}

\item{verbose}{whether to print information about each API request.}

\item{warnings}{whether to print warnings related to API requests.}

\item{progress_bar}{whether to show a progress bar as the paginated resources
are retrieved.}
}
\value{
A list four named elements:
\describe{
\item{resource}{The URL endpoint.}
\item{code}{\href{https://tinyurl.com/8yqvhwf}{HTTP
status code}.}
\item{message}{A string describing the status of the response obtained. It is
"OK" if everything went OK or some other string describing the problem.}
\item{json}{A list of JSON responses (each response is a string).}
}
}
\description{
Performs a GET request on the specified \code{resource_url} and all its
pages.
}
\keyword{internal}
