% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-releases}
\alias{subset-releases}
\alias{[,releases,missing,missing,missing-method}
\alias{[,releases,numeric,missing,missing-method}
\alias{[,releases,character,missing,missing-method}
\alias{[,releases,Date,missing,missing-method}
\title{Subset a releases object}
\usage{
\S4method{[}{releases,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{releases,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{releases,character,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{releases,Date,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{releases} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{releases} object.
}
\description{
You can subset \linkS4class{releases} by identifier (release date) or by
position using the \code{`[`} operator.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get details about all PGS Catalog data releases thus far:
all_releases <- get_releases(date = 'all', progress_bar = FALSE)

#
# Subsetting by position
#
# Releases are, by default, sorted by date in descending order, thus the
# first PGS Catalog release is in the last position of the returned
# `all_releases` object. Here's how you can extract that first release (last
# position in `all_releases`):
all_releases[n(all_releases)]

#
# Subsetting by date (character)
#
date_of_interest <- '2021-06-11'
class(date_of_interest)
all_releases[date_of_interest]

#
# Subsetting by date (Date object)
#
date_of_interest <- as.Date('2021-06-11')
class(date_of_interest)
all_releases[date_of_interest]
\dontshow{\}) # examplesIf}
}
\keyword{internal}
