% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pgs_scoring_file.R
\name{read_scoring_file}
\alias{read_scoring_file}
\title{Read a polygenic scoring file}
\usage{
read_scoring_file(source, protocol = "http", metadata_only = FALSE)
}
\arguments{
\item{source}{PGS scoring file. This can be specified in three forms: (i) a
PGS identifier, e.g. \code{"PGS000001"}, (ii) a path to a local file, e.g.
\code{"~/PGS000001.txt"} or \code{"~/PGS000001.txt.gz"} or (iii) a direct
URL to the PGS Catalog FTP server, e.g.
\code{"http://ftp.ebi.ac.uk/pub/databases/spot/pgs/scores/PGS000001/ScoringFiles/PGS000001.txt.gz"}.}

\item{protocol}{Network protocol for communication with the PGS Catalog FTP
server: either \code{"http"} or \code{"ftp"}.}

\item{metadata_only}{Whether to read only the comment block (header) from the
scoring file.}
}
\value{
The returned value is a named list. The names are copied from the
  arguments passed in \code{source}. Each element of the list contains
  another list of two elements: \code{"metadata"} and \code{"data"}. The
  "metadata" element contains data parsed from the header of the PGS scoring
  file. The "data" element contains a data frame with as many rows as
  variants that constitute the PGS score. The columns can vary. There are
  mandatory and optional columns. The mandatory columns are those that
  identify the variant, effect allele (\code{effect_allele}), and its
  respective weight (\code{effect_weight}) in the score. The columns that
  identify the variant can either be the \code{rsID} or the combination of
  \code{chr_name} and \code{chr_position}. The "data" element will be
  \code{NULL} is argument \code{metadata_only} is \code{TRUE}. For more
  information about the scoring file schema check
  \code{vignette("pgs-scoring-file", package = "quincunx")}.
}
\description{
This function imports a PGS scoring file. For more information about the
scoring file schema check \code{vignette("pgs-scoring-file", package =
"quincunx")}.
}
\examples{

# Read a PGS scoring file by PGS ID
# (internally, it translates the PGS ID
#  to the corresponding FTP URL)
read_scoring_file("PGS000655")

# Equivalent to `read_scoring_file("PGS000655")`
url <- paste0(
  "http://ftp.ebi.ac.uk/",
  "pub/databases/spot/pgs/scores/",
  "PGS000655/ScoringFiles/",
  "PGS000655.txt.gz"
)
read_scoring_file(url)

\dontrun{
# Reading from a local file
read_scoring_file("~/PGS000655.txt.gz")
}
}
