% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nass_api.R
\name{get_options}
\alias{get_options}
\title{Get the parameter options available for some short_desc value.}
\usage{
get_options(key, data_item)
}
\arguments{
\item{key}{Your NASS API key.}

\item{data_item}{The short_desc (data item) string to get options for.}
}
\value{
A tibble df of the unique combinations of other paramters that are
available.
}
\description{
Not all combinations of parameters are available for all data items. This
functions finds the unique combinations that are available.
}
\examples{
\donttest{
key <- Sys.getenv('NASS_KEY')
get_options(key=key, data_item='CORN, GRAIN - ACRES HARVESTED')
}
}
