% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_pop_filter.R
\name{data_pop_filter}
\alias{data_pop_filter}
\title{Remove elements from a data matching filter}
\usage{
data_pop_filter(., remove)
}
\arguments{
\item{.}{data object}

\item{remove}{expression for filter}
}
\value{
data filtered out based on the expression
}
\description{
Shorthand to remove elements from a data frame based on filter and save as the same name
}
\examples{
# this function removes rows matching the filter expression
data.01 <- mtcars
data.02 <- airquality

#task: remove all mpg > 20
data.01 #data.01 data before pop
data_pop_filter(data.01,mpg > 15) #computes and resaves to variable
#note: this is different from subset(data.01,data.01$mpg > 15)
data.01 #modified data after pop based on filter

#task: remove all multiple. remove all elements where Month   == 5 or Solar.R > 50
data.02 #data.02 data before pop
data_pop_filter(data.02,Month   == 5 | Solar.R > 50) #computes and resaves to variable
data.02 #modified data after pop based on filter

}
