% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer.R
\name{integer_}
\alias{integer_}
\alias{integer_bounded}
\alias{integer_left_bounded}
\alias{integer_right_bounded}
\alias{integer_positive}
\alias{integer_negative}
\title{Integer generators}
\usage{
integer_(len = 1L, frac_na = 0, big_int = FALSE)

integer_bounded(left, right, len = 1L, frac_na = 0)

integer_left_bounded(left, len = 1L, frac_na = 0, big_int = FALSE)

integer_right_bounded(right, len = 1L, frac_na = 0, big_int = FALSE)

integer_positive(len = 1L, frac_na = 0, big_int = FALSE)

integer_negative(len = 1L, frac_na = 0, big_int = FALSE)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10.}

\item{frac_na}{The approximate fraction of \code{NA} values to
be included in the vector. A fraction of 0, the default,
will include no \code{NA} values. A fraction of 0.5 would
include around 50\% \code{NA} values.}

\item{big_int}{Should integers near the maximum size be
included? This may cause problems because if the result
of a computation results in an integer larger than the
maximum it will be silently coerced it to a double.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{hedgehog.internal.gen} generator
}
\description{
A set of generators for integer vectors.
}
\examples{
integer_() |> show_example()
integer_(big_int = TRUE) |> show_example()
integer_bounded(left = -5L, right = 5L) |> show_example()
integer_(len = 10L, frac_na = 0.5) |> show_example()
}
