% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double.R
\name{double_}
\alias{double_}
\alias{double_bounded}
\alias{double_left_bounded}
\alias{double_right_bounded}
\alias{double_positive}
\alias{double_negative}
\alias{double_fractional}
\alias{double_whole}
\title{Double generators}
\usage{
double_(len = 1L, frac_na = 0, frac_nan = 0, frac_inf = 0, big_dbl = FALSE)

double_bounded(left, right, len = 1L, frac_na = 0, frac_nan = 0, frac_inf = 0)

double_left_bounded(
  left,
  len = 1L,
  frac_na = 0,
  frac_nan = 0,
  frac_inf = 0,
  big_dbl = FALSE
)

double_right_bounded(
  right,
  len = 1L,
  frac_na = 0,
  frac_nan = 0,
  frac_inf = 0,
  big_dbl = FALSE
)

double_positive(
  len = 1L,
  frac_na = 0,
  frac_nan = 0,
  frac_inf = 0,
  big_dbl = FALSE
)

double_negative(
  len = 1L,
  frac_na = 0,
  frac_nan = 0,
  frac_inf = 0,
  big_dbl = FALSE
)

double_fractional(
  len = 1L,
  frac_na = 0,
  frac_nan = 0,
  frac_inf = 0,
  big_dbl = FALSE
)

double_whole(
  len = 1L,
  frac_na = 0,
  frac_nan = 0,
  frac_inf = 0,
  big_dbl = FALSE
)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10.}

\item{frac_na}{The approximate fraction of \code{NA} values to
be included in the vector. A fraction of 0, the default,
will include no \code{NA} values. A fraction of 0.5 would
include around 50\% \code{NA} values.}

\item{frac_nan}{The approximate fraction of \code{NaN} values
to be included in the vector. A fraction of 0, the
default, will include no \code{NaN} values. A fraction of 0.5
would include around 50\% \code{NaN} values.}

\item{frac_inf}{The approximate fraction of \code{Inf} and
\code{-Inf} values to be included in the vector. A fraction of
0, the default, will include no \code{NA} values. A fraction
of 0.5 would include around 50\% \code{NA} values.}

\item{big_dbl}{Should doubles near the maximum size be
included? This may cause problems because if the result
of a computation results in a double larger than the
maximum it will return \code{Inf}.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{hedgehog.internal.gen} generator
}
\description{
A set of generators for double vectors.
}
\examples{
double_() |> show_example()
double_(big_dbl = TRUE) |> show_example()
double_bounded(left = -5, right = 5) |> show_example()
double_(len = 10L, frac_na = 0.5) |> show_example()
double_(len = 10L, frac_nan = 0.2, frac_inf = 0.2) |> show_example()
}
