% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_plugins.R
\name{create_batches}
\alias{create_batches}
\title{Creates batches of customer arrivals from a dataframe within a \code{dplyr::do} command}
\usage{
create_batches(data, arrival_dist, service_rate = NULL, time = 0)
}
\arguments{
\item{data}{a dataframe with parameters for each batch}

\item{arrival_dist}{a distribution whose support is strictly positive. Either as an object or a non-empty character string. It represents the distribution of arrival times.}

\item{service_rate}{a strictly positive number representing the rate parameter in the exponential distribution for the service times.}

\item{time}{a number greater than or equal to zero.}
}
\description{
Creates batches of customer arrivals from a dataframe within a \code{dplyr::do} command
}
\examples{

library(dplyr)
flight_schedule <- data_frame(
flight = c("F1", "F2"),
time = c(0, 50),
n = c(100, 100),
shape = c(5, 5),
rate = c(1 , 1),
log_mu = c(1 , 1)
)

passenger_df <- flight_schedule \%>\% group_by(flight) \%>\%
do(create_batches(., arrival_dist = "rgamma",
    service_rate = 0.4,
    time = .$time)
)

queue_obj <- with(passenger_df,
    queue_step(arrivals, service, servers = 5)
)
if(require(ggplot2, quietly = TRUE)){
    plot(queue_obj)
}

}
