% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anscombe_linear.R
\docType{data}
\name{anscombe_linear}
\alias{anscombe_linear}
\title{Anscombe's Quartet Linear Data}
\format{
A dataframe with 11 rows and 2 variables:
\itemize{
\item \code{x}: the x-variable
\item \code{y}: the y-variable
}
}
\usage{
anscombe_linear
}
\description{
This dataset contains 11 observations generated by Francis Anscombe to
demonstrate that statistical summary measures alone cannot capture the full
relationship between two variables (here, \code{x} and \code{y}). Anscombe emphasized
the importance of visualizing data prior to calculating summary statistics.
}
\details{
This Dataset has a linear relationship between \code{x} and \code{y}

Additionally, the following statistical summaries hold:
\itemize{
\item mean of \code{x}: 9
\item variance of \code{x}: 11
\item mean of \code{y}: 7.5
\item variance of y: 4.125
\item correlation between \code{x} and \code{y}: 0.816
\item linear regression between \code{x} and \code{y}: \verb{y = 3 + 0.5x}
\item \eqn{R^2} for the regression: 0.67
}
}
\references{
Anscombe, F. J. (1973). "Graphs in Statistical Analysis".
American Statistician. 27 (1): 17–21. doi:10.1080/00031305.1973.10478966.
JSTOR 2682899.
}
\keyword{datasets}
