% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trftest.R
\name{trftest}
\alias{trftest}
\title{Backtesting of Value-at-Risk via Traffic Light Test}
\usage{
trftest(obj)
}
\arguments{
\item{obj}{A list returned by the \code{rollcast} function, that contains
a Value-at-Risk series; any other list that follows the name conventions
of the \code{rollcast} function can be used as well.}
}
\value{
A list of class \code{quarks} is returned with the following elements.
\describe{
\item{model}{selected model for estimation}
\item{method}{selected method for estimation}
\item{p_VaR}{cumulative probability of observing the number of
breaches or fewer for (1 - \code{p})100\%-VaR}
\item{pot_VaR}{number of exceedances for (1 - \code{p})100\%-VaR}
\item{p}{coverage level for (1-\code{p})100\% VaR}
}
}
\description{
The Traffic Light Test, is applied to
previously calculated Value-at-Risk series.
}
\details{
This function uses an object returned by the \code{rollcast} function
of the \code{quarks} package as an input for the
function argument \code{obj}. A list with different elements, such as
the cumulative probabilities for the VaR series within \code{obj},
is returned. Instead of the list, only the traffic light backtesting results
are printed to the R console.
}
\examples{

prices <- DAX$price.close
returns <- diff(log(prices))
n <- length(returns)
nout <- 250 # number of obs. for out-of-sample forecasting
nwin <- 500 # window size for rolling forecasts
results <- rollcast(x = returns, p = 0.975, method = 'age', nout = nout,
                     nwin = nwin)
trftest(results)


}
