% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quant_est.R
\name{quant_est}
\alias{quant_est}
\title{Estimate the Marginal Quantile Given a Specific Treatment Regime}
\usage{
quant_est(beta, x, y, a, prob, tau)
}
\arguments{
\item{beta}{a vector indexing the treatment regime.
It indexes a linear treatment regime:  
\deqn{ d(x)= I\{\beta_0 + \beta_1 x_1 + ... + \beta_k x_k > 0\}.
}{ d(x)= I{\beta_0 + \beta_1*x_1 + ... + \beta_k*x_k > 0}.}}

\item{x}{a matrix of observed covariates from the sample. 
Notice that we assumed the class of treatment regimes is linear.
This is important that columns in \code{x} matches with \code{beta}.}

\item{y}{a vector, the observed responses from a sample}

\item{a}{a vector of 0s and 1s, the observed treatments from a sample}

\item{prob}{a vector, the propensity scores of getting treatment 1 in the samples}

\item{tau}{a numeric value between 0 and 1. The quantile level of interest.}
}
\description{
Estimate the marginal quantile if the entire population follows a 
treatment regime indexed by the given parameters.
This function supports the \code{\link{qestimate}} function.
}
