% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_influence.R
\name{textplot_influence}
\alias{textplot_influence}
\title{Influence plot for text scaling models}
\usage{
textplot_influence(x, n = 30, ...)
}
\arguments{
\item{x}{the object output from \code{influence()} run on the
fitted or predicted scaling model object to be plotted}

\item{n}{the number of features whose influence will be plotted}

\item{...}{additional arguments passed to \code{\link[=plot]{plot()}}}
}
\value{
Creates a base R plot of feature influences of the median influence
by the log10 median rate of the feature, and invisibly returns the elements
from the call to \code{\link[=plot]{plot()}}.
}
\description{
Plot the results of a fitted scaling model, from (e.g.) a predicted
\link{textmodel_affinity} model.
}
\examples{
tmod <- textmodel_affinity(quanteda::data_dfm_lbgexample, y = c("L", NA, NA, NA, "R", NA))
pred <- predict(tmod)
textplot_influence(influence(pred))
}
\seealso{
\code{\link[=textmodel_affinity]{textmodel_affinity()}}

\code{\link[=influence.predict.textmodel_affinity]{influence.predict.textmodel_affinity()}}
}
\author{
Patrick Perry and Kenneth Benoit
}
\keyword{internal}
\keyword{textplot}
