% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_survey.R
\name{read_survey}
\alias{read_survey}
\title{Read a CSV file exported from Qualtrics}
\usage{
read_survey(file_name, strip_html = TRUE, import_id = FALSE,
  legacy = FALSE)
}
\arguments{
\item{file_name}{String. A CSV data file.}

\item{strip_html}{Logical. If \code{TRUE}, then remove HTML tags. Defaults
to \code{TRUE}.}

\item{import_id}{Logical. If \code{TRUE}, use Qualtrics import IDs instead of
question IDs as column names. Defaults to \code{FALSE}.}

\item{legacy}{Logical. If \code{TRUE}, then import "legacy" format CSV files
(as of 2017). Defaults to \code{FALSE}.}
}
\value{
A data frame. Variable labels are stored as attributes. They are not
printed on the console but are visibile in the RStudio viewer.
}
\description{
Reads comma separated CSV files generated by Qualtrics
software. The second line containing the variable labels is imported.
Repetitive introductions to matrix questions are automatically removed.
Variable labels are stored as attributes.
}
\examples{
\dontrun{
# Generic use of read_survey()
df <- read_survey("<YOUR-PATH-TO-CSV-FILE>")
}
# Example using current data format
file <- system.file("extdata", "sample.csv", package = "qualtRics")
df <- read_survey(file)

# Example using legacy data format
file <- system.file("extdata", "sample_legacy.csv", package = "qualtRics")
df <- read_survey(file, legacy = TRUE)


}
