% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh-plot.R, R/mesh_plot_mesh3d.R
\name{mesh_plot}
\alias{mesh_plot}
\alias{mesh_plot.BasicRaster}
\alias{mesh_plot.RasterLayer}
\alias{mesh_plot.stars}
\alias{mesh_plot.TRI}
\alias{mesh_plot.quadmesh}
\alias{mesh_plot.mesh3d}
\title{Plot as a mesh}
\usage{
mesh_plot(
  x,
  crs = NULL,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL
)

\method{mesh_plot}{BasicRaster}(
  x,
  crs = NULL,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL
)

\method{mesh_plot}{RasterLayer}(
  x,
  crs = NULL,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL
)

\method{mesh_plot}{stars}(
  x,
  crs = NULL,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL
)

\method{mesh_plot}{TRI}(
  x,
  crs = NULL,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL
)

\method{mesh_plot}{quadmesh}(
  x,
  crs = NULL,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL
)

\method{mesh_plot}{mesh3d}(
  x,
  crs = NULL,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL
)
}
\arguments{
\item{x}{object to convert to mesh and plot}

\item{crs}{target map projection}

\item{col}{colours to use, defaults to that used by \code{\link[graphics:image]{graphics::image()}}}

\item{add}{add to existing plot or start a new one}

\item{zlim}{absolute range of data to use for colour scaling (if \code{NULL} the data range is used)}

\item{...}{passed through to \code{base::plot}}

\item{coords}{optional input raster of coordinates of each cell, see details}
}
\value{
nothing, used for the side-effect of creating or adding to a plot
}
\description{
Convert to a quadmesh and plot in efficient vectorized form using 'grid'.
}
\details{
The mesh may be reprojected prior to plotting using the 'crs' argument to
define the target map projection in 'PROJ string' format. (There is no
"reproject" function for quadmesh, this is performed directly on the x-y
coordinates of the 'quadmesh' output). The 'col' argument are mapped to the input pplied
object data as in 'image', and applied relative to 'zlim' if su.

If \code{coords} is supplied, it is currently assumed to be a 2-layer \code{RasterBrick} with
longitude and latitude as the \emph{cell values}. These are used to geographically locate
the resulting mesh, and will be transformed to the \code{crs} if that is supplied. This is
modelled on the approach to curvilinear grid data used in the \code{angstroms} package. There
the function \code{angstroms::romsmap()} and `angstroms::romscoords()`` are used to separate the complicated
grid geometry from the grid data itself. A small fudge is applied to extend the coordinates
by 1 cell to avoid losing any data due to the half cell outer margin (get in touch if this causes problems!).
}
\examples{
mesh_plot(worldll)
rr <- raster::crop(worldll, raster::extent(-179, 179, -89, 89))
mesh_plot(rr, crs = "+proj=laea +datum=WGS84")
}
