% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh-plot.R
\name{mesh_plot}
\alias{mesh_plot}
\alias{mesh_plot.BasicRaster}
\alias{mesh_plot.RasterLayer}
\title{Plot as a mesh}
\usage{
mesh_plot(x, crs = NULL, colfun = NULL, add = FALSE, ...)

\method{mesh_plot}{BasicRaster}(x, crs = NULL, colfun = NULL,
  add = FALSE, ...)

\method{mesh_plot}{RasterLayer}(x, crs = NULL, colfun = NULL,
  add = FALSE, ...)
}
\arguments{
\item{x}{object to convert to mesh and plot}

\item{crs}{target map projection}

\item{colfun}{colour function to use, `viridis` is the default}

\item{add}{add to existing plot or start a new one}

\item{...}{ignored}
}
\value{
nothing, used for the side-effect of creating or adding to a plot
}
\description{
Convert to a quadmesh and plot in efficient vectorized form using 'grid'.
}
\details{
The mesh may be reprojected prior to plotting using the 'crs' argument to
define the target map projection in 'PROJ string' format. (There is no
"reproject" function for quadmesh, this is performed directly on the x-y
coordinates of the 'quadmesh' output). The 'colfun' argument is used to
generate colours which are mapped to the input object data as in 'image'.
}
\examples{
mesh_plot(worldll)
## crop otherwise out of bounds from PROJ
mesh_plot(raster::crop(worldll, raster::extent(-179, 179, -89, 89)), crs = "+proj=laea")
mesh_plot(worldll, crs = "+proj=moll")
prj <- "+proj=lcc +datum=WGS84 +lon_0=147 +lat_0=-40 +lat_1=-55 +lat_2=-20"
mesh_plot(etopo, crs = prj, add = FALSE, colfun = function(n = 20) grey(seq(0, 1, length = n)))
mesh_plot(worldll, crs = prj, add = TRUE)
}
