% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cover_calc.R
\name{cover_calc}
\alias{cover_calc}
\title{Calculate species cover}
\usage{
cover_calc(data, spp, prop = TRUE, total = FALSE)
}
\arguments{
\item{data}{A data frame with each row representing a sampling unit (ex. a
quadrat or photo).}

\item{spp}{The column names containing all observations to be used in the
proportion calculation. It is important to note that the proportions
will be scaled to the total observations in these columns for each quadrat.}

\item{prop}{If \code{prop = TRUE}, the resulting cover will be proportions. If
\code{prop = FALSE}, the resulting cover will be in percentages.}

\item{total}{If \code{total = TRUE}, a column containing the total number of observations
at each sampling unit will be returned in a new column called \code{total_pts}. This will
not be returned if \code{total = FALSE}.}
}
\value{
A data frame containing scaled observation cover.
}
\description{
Convert the number of observations for each species or non-species
to proportion or percent cover within each row based on the total number
of observations in each row. Useful for quadrats with varying numbers of
observations to calculate each row's percent cover all at once.
}
\examples{
#create data set for example
Sites <- as.factor(c("One", "One", "Two", "Two", "Three", "Three"))
Transect <- as.factor(c("1-Shallow", "2-Shallow", "1-Shallow", "2-Shallow",
    "1-Shallow", "2-Shallow"))
Acropora.sp <- c(1, 2, 3, 4, 5, 6)
Gardineroseris.sp <- c(6, 1, 2, 3, 4, 5)
Psammocora.sp <- c(5, 6, 1, 2, 3, 4)
Leptastrea.sp <- c(4, 5, 6, 1, 2, 3)
coral_cover <- data.frame(Sites, Transect, Acropora.sp, Gardineroseris.sp,
                          Psammocora.sp, Leptastrea.sp)

cover_calc(data = coral_cover, spp = names(coral_cover[3:6]), prop = TRUE, total = TRUE)

cover_calc(data = coral_cover, spp = names(coral_cover[3:6]), prop = FALSE, total = FALSE)
}
