% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_sim_geno.R
\name{subset.sim_geno}
\alias{subset.sim_geno}
\alias{[.sim_geno}
\title{Subsetting imputed genotypes}
\usage{
\method{subset}{sim_geno}(x, ind = NULL, chr = NULL, ...)

\method{[}{sim_geno}(x, ind = NULL, chr = NULL)
}
\arguments{
\item{x}{Imputed genotypes as output from \code{\link[=sim_geno]{sim_geno()}}.}

\item{ind}{A vector of individuals: numeric indices, logical
values, or character string IDs}

\item{chr}{A vector of chromosomes: logical values, or character
string IDs. Numbers are interpreted as character string IDs.}

\item{...}{Ignored.}
}
\value{
An object of class \code{"sim_geno"}, like the input
with the selected individuals and/or chromsomes; see \code{\link[=sim_geno]{sim_geno()}}.
}
\description{
Pull out a specified set of individuals and/or chromosomes from
the results of \code{\link[=sim_geno]{sim_geno()}}.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
\dontshow{grav2 <- grav2[1:8,c(1,2)]}
dr <- sim_geno(grav2, n_draws=4)
# keep just individuals 1:5, chromosome 2
drsub <- dr[1:5,2]
# keep just chromosome 2
drsub2 <- dr[,2]
}
\keyword{utilities}
